/*  -*- c++ -*-  (for Emacs)
 *
 *  dtrainedrecogrecord.h
 *  Digest
 * 
 *  Created by Aidan Lane on Fri Aug 12 2005.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef DTRAINEDRECOGRECORD_H
#define DTRAINEDRECOGRECORD_H


#include <QByteArray>
#include <QDate>
#include <QHash>
#include <QList>
#include <QSet>
#include <QString>
#include <QVariant>


/*!
 * \b Warning: This is not an actual trained recogniser, just a record of one.
 *
 * \b Note: This is a class, not a struct, so that it can be used as a template
 *          parameter.
 */
class DTrainedRecogRecord {
public:
  DTrainedRecogRecord( int id = -1, const QString& label = QString() )
    : id(id),
      label(label),
      external(false),
      ready(false) {}
  int                       id;
  QString                   label;
  QByteArray                recogniserKey;
  QDate                     date;
  bool                      external; /*! As the DB can be used to store the
					results of external experiments. */
  QString                   notes;
  bool                      ready; /*! Prevents race conditions,
				     e.g. if data file is renamed. */
  QString                   modelFile;
  QList<QByteArray>         orderedFeatures;
  QSet<int>                 trainingSet;
  QHash<QString, QVariant>  options;
};


#endif  // ! DTRAINEDRECOGRECORD_H
