/*  -*- c++ -*-  (for Emacs)
 *
 *  digestdbmodelevents.h
 *  Digest
 * 
 *  Created by Aidan Lane on Fri Aug 12 2005.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef DIGESTDBMODELEVENTS_H
#define DIGESTDBMODELEVENTS_H


#include "MvcCore/modelevents.h"
#include "MvcCore/genericcontainers.h"

#include "mvcdigestdb.h"
#include "digestdbcontainers.h"


class MDigestDbEvent : public MEvent {
public:
  enum Type {
    ClassAdd            = MEvent::User,
    ClassUpdate,
    ClassesRemove,
    CollectionAdd,
    CollectionUpdate,
    CollectionsRemove,
    ExperimentAdd,
    ExperimentUpdate,
    ExperimentsRemove,
    GestureAdd,
    GestureUpdate,
    GesturesChangeClasses,
    GesturesChangeCollections,
    GesturesRemove,
    TrainedRecogAdd,
    TrainedRecogUpdate,
    TrainedRecogsRemove,
    User                = MEvent::User + 1000
  };

  MDigestDbEvent( Type type )
    : MEvent((MEvent::Type)type) {}

  /*! Returns MvcDigestDb::id(). */
  inline static MvcModuleId_t classModuleId() { return MvcDigestDb::id(); }
  /*! Returns classModuleId(). */
  virtual MvcModuleId_t moduleId() const { return classModuleId(); }
};


class MClassAddEvent : public MDigestDbEvent,
		       public DClassRecordContainer {
public:
  MClassAddEvent( const DClassRecord& record )
    : MDigestDbEvent(ClassAdd),
      DClassRecordContainer(record) {}
};

class MClassUpdateEvent : public MDigestDbEvent,
			  public DClassRecordContainer {
public:
  MClassUpdateEvent( const DClassRecord& record )
    : MDigestDbEvent(ClassUpdate),
      DClassRecordContainer(record) {}
};

class MClassesRemoveEvent : public MDigestDbEvent,
			    public IdSetContainer {
public:
  MClassesRemoveEvent( const IdSet& idSet )
    : MDigestDbEvent(ClassesRemove),
      IdSetContainer(idSet) {}
};


class MCollectionAddEvent : public MDigestDbEvent,
			    public DCollectionRecordContainer {
public:
  MCollectionAddEvent( const DCollectionRecord& record )
    : MDigestDbEvent(CollectionAdd),
      DCollectionRecordContainer(record) {}
};

class MCollectionUpdateEvent : public MDigestDbEvent,
			       public DCollectionRecordContainer {
public:
  MCollectionUpdateEvent( const DCollectionRecord& record )
    : MDigestDbEvent(CollectionUpdate),
      DCollectionRecordContainer(record) {}
};

class MCollectionsRemoveEvent : public MDigestDbEvent,
				public IdSetContainer {
public:
  MCollectionsRemoveEvent( const IdSet& idSet )
    : MDigestDbEvent(CollectionsRemove),
      IdSetContainer(idSet) {}
};


class MExperimentAddEvent : public MDigestDbEvent,
			    public DExperimentRecordContainer {
public:
  MExperimentAddEvent( const DExperimentRecord& record )
    : MDigestDbEvent(ExperimentAdd),
      DExperimentRecordContainer(record) {}
};

class MExperimentUpdateEvent : public MDigestDbEvent,
			       public DExperimentRecordContainer {
public:
  MExperimentUpdateEvent( const DExperimentRecord& record )
    : MDigestDbEvent(ExperimentUpdate),
      DExperimentRecordContainer(record) {}
};

class MExperimentsRemoveEvent : public MDigestDbEvent,
				public IdSetContainer {
public:
  MExperimentsRemoveEvent( const IdSet& idSet )
    : MDigestDbEvent(ExperimentsRemove),
      IdSetContainer(idSet) {}
};


class MGestureAddEvent : public MDigestDbEvent,
			 public DGestureRecordContainer {
public:
  MGestureAddEvent( const DGestureRecord& record )
    : MDigestDbEvent(GestureAdd),
      DGestureRecordContainer(record) {}
};

class MGestureUpdateEvent : public MDigestDbEvent,
			    public DGestureRecordContainer {
public:
  MGestureUpdateEvent( const DGestureRecord& record )
    : MDigestDbEvent(GestureUpdate),
      DGestureRecordContainer(record) {}
};

/*! This event exists for both convenience and efficiency purposes. */
class MGesturesChangeClassesEvent : public MDigestDbEvent,
				    public IdSetContainer,
				    public AddSetContainer<int>,
				    public RemoveSetContainer<int> {
public:
  MGesturesChangeClassesEvent( const IdSet& idSet,
			       const IdSet& addSet,
			       const IdSet& removeSet )
    : MDigestDbEvent(GesturesChangeClasses),
      IdSetContainer(idSet),
      AddSetContainer<int>(addSet),
      RemoveSetContainer<int>(removeSet) {}
};

/*! This event exists for both convenience and efficiency purposes. */
class MGesturesChangeCollectionsEvent : public MDigestDbEvent,
					public IdSetContainer,
					public AddSetContainer<int>,
					public RemoveSetContainer<int> {
public:
  MGesturesChangeCollectionsEvent( const IdSet& idSet,
				   const IdSet& addSet,
				   const IdSet& removeSet)
    : MDigestDbEvent(GesturesChangeCollections),
      IdSetContainer(idSet),
      AddSetContainer<int>(addSet),
      RemoveSetContainer<int>(removeSet) {}
};

class MGesturesRemoveEvent : public MDigestDbEvent,
			     public IdSetContainer {
public:
  MGesturesRemoveEvent( const IdSet& idSet )
    : MDigestDbEvent(GesturesRemove),
      IdSetContainer(idSet) {}
};


class MTrainedRecogAddEvent : public MDigestDbEvent,
			      public DTrainedRecogRecordContainer {
public:
  MTrainedRecogAddEvent( const DTrainedRecogRecord& record )
    : MDigestDbEvent(TrainedRecogAdd),
      DTrainedRecogRecordContainer(record) {}
};

class MTrainedRecogUpdateEvent : public MDigestDbEvent,
				 public DTrainedRecogRecordContainer {
public:
  MTrainedRecogUpdateEvent( const DTrainedRecogRecord& record )
    : MDigestDbEvent(TrainedRecogUpdate),
      DTrainedRecogRecordContainer(record) {}
};

class MTrainedRecogsRemoveEvent : public MDigestDbEvent,
				  public IdSetContainer {
public:
  MTrainedRecogsRemoveEvent( const IdSet& idSet )
    : MDigestDbEvent(TrainedRecogsRemove),
      IdSetContainer(idSet) {}
};


#endif //  ! DIGESTDBMODELEVENTS_H
