/*  -*- c++ -*-  (for Emacs)
 *
 *  abstractdigestdbview.h
 *  Digest
 * 
 *  Created by Aidan Lane on Fri Aug 12 2005.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef ABSTRACTDIGESTDBVIEW_H
#define ABSTRACTDIGESTDBVIEW_H


#include "MvcCore/abstractview.h"

#include <QPointer>

#include "digestdbviewevents.h"

class QSqlDatabase;

class DigestDbController;
class DigestDbModel;


class AbstractDigestDbView : public AbstractView {

public:
  AbstractDigestDbView( QObject* objectPtr );

  DigestDbController* digestDbController() const;
  DigestDbModel*      digestDbModel() const;

  const QSqlDatabase& database() const;

  /*! Returns MvcDigestDb::id(). */
  inline static MvcModuleId_t classModuleId() { return MvcDigestDb::id(); }
  /*! Returns classModuleId(). */
  virtual MvcModuleId_t moduleId() const { return classModuleId(); }


protected:
  virtual void dispatchEvent( VEvent* );

  virtual void changeControllerEvent( VChangeControllerEvent* );
  virtual void modelChangedEvent( VModelChangedEvent* );
  virtual void resetEvent( VEvent* );

  virtual void changeDigestDbControllerEvent( VChangeControllerEvent* );
  virtual void digestDbModelChangedEvent( VModelChangedEvent* );
  virtual void digestDbResetEvent( VEvent* );

  // The following implementations do nothing, derivative classes are left to
  // add functionality.
  virtual void classesEvent( VClassesEvent* ) {}
  virtual void collectionsEvent( VCollectionsEvent* ) {}
  virtual void experimentsEvent( VExperimentsEvent* ) {}
  virtual void gesturesEvent( VGesturesEvent* ) {}
  virtual void trainedRecogsEvent( VTrainedRecogsEvent* ) {}

  void postDigestDbEvent( CEvent* );


private:
  // Temporary caches:
  QPointer<DigestDbController> c_digestDbController;
  QPointer<DigestDbModel>      c_digestDbModel;
};


#endif //  ! ABSTRACTDIGESTDBVIEW_H
