/*  -*- c++ -*-  (for Emacs)
 *
 *  settingscontrollerevents.h
 *  Digest
 * 
 *  Created by Aidan Lane on Wed Aug 31 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef SETTINGSCONTROLLEREVENTS_H
#define SETTINGSCONTROLLEREVENTS_H


#include "MvcCore/controllerevents.h"
#include "MvcCore/genericcontainers.h"

#include "mvcsettings.h"


class CSettingsEvent : public CEvent {

public:
  enum Type {
    SettingsChangeValue  = CEvent::User,
    SettingsRemoveKey,
    SettingsRemoveAll,
    SettingsSyncAll,
    User                 = CEvent::User + 1000
  };

  CSettingsEvent( Type type,
		  QObject* sender = 0, Flags flags = NoFlags )
    : CEvent((CEvent::Type)type, sender, flags) {}

  /*! Returns MvcSettings::id(). */
  inline static MvcModuleId_t classModuleId() { return MvcSettings::id(); }
  /*! Returns classModuleId(). */
  virtual MvcModuleId_t moduleId() const { return classModuleId(); }
};


class CSettingsChangeValueEvent : public CSettingsEvent,
				  public KeyContainer, public ValueContainer {
public:
  CSettingsChangeValueEvent( const QString& key, const QVariant& value,
			     QObject* sender = 0, Flags flags = NoFlags )
    : CSettingsEvent(SettingsChangeValue, sender, flags),
      KeyContainer(key),
      ValueContainer(value) {}
};


class CSettingsRemoveKeyEvent : public CSettingsEvent, public KeyContainer {
public:
  CSettingsRemoveKeyEvent( const QString& key,
			   QObject* sender = 0, Flags flags = NoFlags )
    : CSettingsEvent(SettingsRemoveKey, sender, flags),
      KeyContainer(key) {}
};


#endif //  ! SETTINGSCONTROLLEREVENTS_H
