/*  -*- c++ -*-  (for Emacs)
 *
 *  settingsmodel.h
 *  Digest
 * 
 *  Created by Aidan Lane on Wed Aug 31 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef SETTINGSMODEL_H
#define SETTINGSMODEL_H


#include "MvcCore/abstractmodel.h"

#include <QPointer>
#include <QSettings>

#include "settingsmodelevents.h"

class SettingsController;


class SettingsModel : public QObject, public AbstractModel {

  Q_OBJECT

public:
  SettingsModel( const QString& organization,
		 const QString& application = QString(),
		 QObject* parent = 0 );
  SettingsModel( QSettings::Scope scope,
		 const QString& organization,
		 const QString& application = QString(),
		 QObject* parent = 0 );
  SettingsModel( QSettings::Format format,
		 QSettings::Scope scope,
		 const QString& organization,
		 const QString& application = QString(),
		 QObject* parent = 0 );
  SettingsModel( const QString& fileName,
		 QSettings::Format format,
		 QObject* parent = 0 );
  SettingsModel( QObject* parent = 0 );

  SettingsController* settingsController() const;

  const QSettings* constSettings() const;
  QVariant value( const QString& key,
		  const QVariant& defaultValue = QVariant() ) const;

  /*! Returns MvcSettings::id(). */
  inline static MvcModuleId_t classModuleId() { return MvcSettings::id(); }
  /*! Returns classModuleId(). */
  virtual MvcModuleId_t moduleId() const { return classModuleId(); }


protected:
  inline virtual void customEvent( QEvent* e ) {
    MEvent* me = dynamic_cast<MEvent*>(e); // slow :-(
    if ( me != 0 ) dispatchEvent(me);
  }
  virtual void dispatchEvent( MEvent* );

  virtual void changeControllerEvent( MChangeControllerEvent* );

  virtual void settingsChangeValueEvent( MSettingsChangeValueEvent* );
  virtual void settingsRemoveKeyEvent( MSettingsRemoveKeyEvent* );
  virtual void settingsRemoveAllEvent( MSettingsEvent* );
  virtual void settingsSyncAllEvent( MSettingsEvent* );

  QSettings* settings() const;


private:
  // Persistent state:
  QSettings* m_settings;

  // Temporary caches:
  QPointer<SettingsController> c_settingsController;
};


#endif // ! SETTINGSMODEL_H
