/*  -*- c++ -*-  (for Emacs)
 *
 *  settingsmodelevents.h
 *  Digest
 * 
 *  Created by Aidan Lane on Wed Aug 31 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef SETTINGSMODELEVENTS_H
#define SETTINGSMODELEVENTS_H


#include "MvcCore/modelevents.h"
#include "MvcCore/genericcontainers.h"

#include "mvcsettings.h"


class MSettingsEvent : public MEvent {

public:
  enum Type {
    SettingsChangeValue  = MEvent::User,
    SettingsRemoveKey,
    SettingsRemoveAll,
    SettingsSyncAll,
    User                 = MEvent::User + 1000
  };

  MSettingsEvent( Type type )
    : MEvent((MEvent::Type)type) {}

  /*! Returns MvcSettings::id(). */
  inline static MvcModuleId_t classModuleId() { return MvcSettings::id(); }
  /*! Returns classModuleId(). */
  virtual MvcModuleId_t moduleId() const { return classModuleId(); }
};


class MSettingsChangeValueEvent : public MSettingsEvent,
				  public KeyContainer, public ValueContainer {
public:
  MSettingsChangeValueEvent( const QString& key, const QVariant& value )
    : MSettingsEvent(SettingsChangeValue),
      KeyContainer(key),
      ValueContainer(value) {}
};


class MSettingsRemoveKeyEvent : public MSettingsEvent, public KeyContainer {
public:
  MSettingsRemoveKeyEvent( const QString& key )
    : MSettingsEvent(SettingsRemoveKey),
      KeyContainer(key) {}
};


#endif //  ! SETTINGSMODELEVENTS_H
