/*  -*- c++ -*-  (for Emacs)
 *
 *  abstractsettingsview.h
 *  Digest
 * 
 *  Created by Aidan Lane on Wed Aug 31 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef ABSTRACTSETTINGSVIEW_H
#define ABSTRACTSETTINGSVIEW_H


#include "MvcCore/abstractview.h"

#include "settingsviewevents.h"


class SettingsModel;
class SettingsController;


class AbstractSettingsView : public AbstractView {

public:
  AbstractSettingsView( QObject* objectPtr );

  SettingsController* settingsController() const;
  SettingsModel*      settingsModel() const;

   /*! Returns MvcSettings::id(). */
  inline static MvcModuleId_t classModuleId() { return MvcSettings::id(); }
  /*! Returns classModuleId(). */
  virtual MvcModuleId_t moduleId() const { return classModuleId(); }


protected:
  virtual void dispatchEvent( VEvent* );

  virtual void changeControllerEvent( VChangeControllerEvent* );
  virtual void modelChangedEvent( VModelChangedEvent* );
  virtual void resetEvent( VEvent* );

  /*!
   * Conveniance event handler.
   *
   * \em Warning: It will be called in \em addition to changeControllerEvent().
   * It's useful when mixing multiple views together.
   *
   * This implementation does nothing.
   */
  virtual void changeSettingsControllerEvent( VChangeControllerEvent* ) {}

  /*!
   * Conveniance event handler.
   *
   * \em Warning: It will be called in \em addition to modelChangedEvent().
   * It's useful when mixing multiple views together.
   *
   * This implementation does nothing.
   */
  virtual void settingsModelChangedEvent( VModelChangedEvent* ) {}

  /*!
   * Conveniance event handler.
   *
   * \em Warning: It will be called in \em addition to resetEvent().
   * It's useful when mixing multiple views together.
   *
   * This implementation does nothing.
   */
  virtual void settingsResetEvent( VEvent* ) {}

  // The following implementations do nothing, derivative classes are left to
  // add functionality.
  virtual void settingsValueChangedEvent( VSettingsValueChangedEvent* ) {}
  virtual void settingsKeyRemovedEvent( VSettingsKeyRemovedEvent* ) {}

  void postSettingsEvent( CEvent* event );


private:
  // Temporary caches:
  QPointer<SettingsController> c_settingsController;
  QPointer<SettingsModel>      c_settingsModel;
};


#endif //  ! ABSTRACTSETTINGSVIEW_H
