/*  -*- c++ -*-  (for Emacs)
 *
 *  settingsviewevents.h
 *  Digest
 * 
 *  Created by Aidan Lane on Wed Aug 31 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef SETTINGSVIEWEVENTS_H
#define SETTINGSVIEWEVENTS_H


#include "MvcCore/viewevents.h"
#include "MvcCore/genericcontainers.h"

#include "mvcsettings.h"


class AbstractSettingsElement;


class VSettingsEvent : public VEvent {
public:
  enum Type {
    SettingsValueChanged  = VEvent::User,
    SettingsKeyRemoved,
    User                  = VEvent::User + 1000
  };

  VSettingsEvent( Type type, MvcBase* sender )
    : VEvent((VEvent::Type)type, sender ) {}

  /*! Returns MvcSettings::id(). */
  inline static MvcModuleId_t classModuleId() { return MvcSettings::id(); }
  /*! Returns classModuleId(). */
  virtual MvcModuleId_t moduleId() const { return classModuleId(); }
};


class VSettingsValueChangedEvent : public VSettingsEvent,
				   public KeyContainer, public ValueContainer {
public:
  VSettingsValueChangedEvent( const QString& key, const QVariant& value,
			      MvcBase* sender )
    : VSettingsEvent(SettingsValueChanged, sender),
      KeyContainer(key),
      ValueContainer(value) {}
};


class VSettingsKeyRemovedEvent : public VSettingsEvent, public KeyContainer {
public:
  VSettingsKeyRemovedEvent( const QString& key, MvcBase* sender )
    : VSettingsEvent(SettingsKeyRemoved, sender),
      KeyContainer(key) {}
};


#endif //  ! SETTINGSVIEWEVENTS_H
