/*  -*- c++ -*-  (for Emacs)
 *
 *  recogniserbrowser.h
 *  Digest
 * 
 *  Created by Aidan Lane on Tue Jul 21 2005.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef RECOGNISERBROWSER_H
#define RECOGNISERBROWSER_H


#include "DigestGuiCore/guicomponentwidgets.h"

#include <jni.h>

#include "ui_recogniserbrowserform.h"


class QItemSelection;
class QItemSelectionModel;
class QSqlQueryModel;
class QStandardItemModel;


class RecogniserBrowser : public GuiDbComponentDialog {

  Q_OBJECT

public:
  RecogniserBrowser( AbstractController* controller,
		     JavaVM* jvm,
		     QWidget* parent = 0, Qt::WindowFlags flags = 0 );

public slots:
  void refreshModel();


protected:
  void showEvent( QShowEvent* );

  void resetEvent( VEvent* );
  void trainedRecogsEvent( VTrainedRecogsEvent* );


private slots:
  void on_trainNewButton_clicked();
  void on_removeButton_clicked();
  void on_detailsHtmlWidget_anchorClicked( const QUrl& link );

  void onSelectionChanged();

  void updateDetailsText();


private:
  QString trainedRecogRecordAsHtml( const DTrainedRecogRecord& record ) const;

  JavaVM* m_jvm;

  Ui::RecogniserBrowserForm ui;

  QSqlQueryModel* m_queryModel;
  QItemSelectionModel* m_selectionModel;

  QStandardItemModel* m_dummyModel;
};


#endif  // ! RECOGNISERBROWSER_H
