/*  -*- c++ -*-  (for Emacs)
 *
 *  recognisertestpad.h
 *  Digest
 * 
 *  Created by Aidan Lane on Tue Jul 12 2005.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef RECOGNISERTESTPAD_H
#define RECOGNISERTESTPAD_H


#include "DigestGuiCore/guicomponentwidgets.h"

#include <QHash>
#include <QMultiMap>

#include <jni.h>

#include "GestureRecognition/abstractrecogniser.h"

#include "ui_recognisertestpadform.h"

class DigestDbController;
class SettingsController;


class RecogniserTestPad : public GuiDbComponentDialog {

  Q_OBJECT

public:
  RecogniserTestPad( DigestDbController* digestDbController,
		     SettingsController* settingsController,
		     JavaVM* jvm,
		     QWidget* parent = 0, Qt::WindowFlags flags = 0 );


private slots:
  void on_enableAllButton_clicked();
  void on_enableNoneButton_clicked();
  void on_recogniseButton_clicked();
  void on_clearButton_clicked();

  void recognise( const StrokeList& strokes );
  void updateInfoText();


protected:
  void showEvent( QShowEvent* event );

  void resetEvent( VEvent* );
  void trainedRecogsEvent( VTrainedRecogsEvent* );


private:
  void refreshTrainedRecogList();
  void initRecognisers();
  void setAllRecognisersCheckState( Qt::CheckState state );

  QString trainedRecogRecordAsHtml( const DTrainedRecogRecord& record ) const;
  
  QString recogResultsAsHtml
  ( const QMultiMap<QString,ClassProbabilities>& results ) const;

  Ui::RecogniserTestPadForm   m_ui;
  JavaVM*                     m_jvm;

  // Recognisers: instance -> label
  // Note: It couldn't be label -> instance, as LABELS ARE *NOT* ALWAYS UNIQUE
  QHash<AbstractRecogniser*, QString>  m_recognisers;
};


#endif  // ! RECOGNISERTESTPAD_H
