/*  -*- c++ -*-  (for Emacs)
 *
 *  sqlbrowser.h
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Jun 30 2005.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  Based on the Qt Toolkit 4.01 SqlBrowser demonstration application.
 *  Copyright (C) 1992-2005 Trolltech AS. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef SQLBROWSER_H
#define SQLBROWSER_H


#include "DigestGuiCore/guicomponentwidgets.h"

#include <QRegExp>
#include <QSqlQuery>

#include "ui_sqlbrowserform.h"


class QSqlQueryModel;
class QSqlTableModel;


class SqlBrowser: public GuiDbComponentDialog {

  Q_OBJECT

public:
  SqlBrowser( AbstractController* controller,
	      QWidget* parent = 0, Qt::WindowFlags flags = 0 );

protected:
  void showEvent( QShowEvent* );

  void resetEvent( VEvent* );
  void classesEvent( VClassesEvent* );
  void collectionsEvent( VCollectionsEvent* );
  void experimentsEvent( VExperimentsEvent* );
  void gesturesEvent( VGesturesEvent* );
  void trainedRecogsEvent( VTrainedRecogsEvent* );


private slots:
  void refreshQuery();
  void importData();
  void exportData();
  void execUserQuery();
  void showTable( const QString& table );
  void setQueryStatus( const QString& message );
  void refreshTableList();
  void updateNumRecordsLabel();

  void on_tableListWidget_itemSelectionChanged();
  void on_submitButton_clicked();
  void on_clearButton_clicked();


private:
  static QString formatSqlValue( QString value );

  // Temporary state:
  Ui::SqlBrowserForm  m_ui;
  QSqlTableModel*     m_editModel;
  QSqlQueryModel*     m_queryModel;
  QString             m_queryString;

  // Temporary caches:
  QRegExp c_regexp;
};


#endif  // ! SQLBROWSER_H
