/*  -*- c++ -*-  (for Emacs)
 *
 *  featureslistwidget.h
 *  Digest
 * 
 *  Created by Aidan Lane on Tue Aug 16 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef FEATURESLISTWIDGET_H
#define FEATURESLISTWIDGET_H


#include "WidgetPack/headedlistwidget.h"

#include <QPoint>


/*!
 * Feature items may be dragged from one FeaturesListWidget to another.
 *
 * Items can be re-ordered by dragging them around within a single
 * FeaturesListWidget.
 */
class FeaturesListWidget : public HeadedListWidget {

public:
  enum { FeatureKeyRole = Qt::UserRole };

  FeaturesListWidget( QWidget* parent = 0 );

  void addFeature( const QByteArray& key );
  void insertFeature( int row, const QByteArray& key );

  QByteArray itemFeatureKey( QListWidgetItem* item );
  QByteArray rowFeatureKey( int row );

  const QPen& insertionLinePen() const;
  void setInsertionLinePen( const QPen& pen );


protected:
  virtual void startDrag( Qt::DropActions supportedActions );

  virtual void mousePressEvent( QMouseEvent* event );

  virtual void dragEnterEvent( QDragEnterEvent* event );
  virtual void dragLeaveEvent( QDragLeaveEvent* event );
  virtual void dragMoveEvent( QDragMoveEvent* event );
  virtual void dropEvent( QDropEvent* event );

  virtual void paintEvent( QPaintEvent* event );


private:
  QPen m_insertionLinePen;

  QPoint m_dragStartPos;

  bool m_drawInsertionLine;
  int  m_insertionLineRow;
};


#endif  // ! FEATURESLISTWIDGET_H
