/*  -*- c++ -*-  (for Emacs)
 *
 *  trainingassistant.h
 *  Digest
 * 
 *  Created by Aidan Lane on Tue Jul 21 2005.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef TRAININGASSISTANT_H
#define TRAININGASSISTANT_H


#include "DigestGuiCore/guicomponentwidgets.h"

#include <QByteArray>
#include <QList>
#include <QSet>

#include <jni.h>

#include "ui_trainingassistantform.h"

class QItemSelectionModel;
class QStandardItemModel;

class AbstractRecogniser;
class CategoryItemModel;
class GestureQueryModel;


class TrainingAssistant : public GuiDbComponentDialog {

  Q_OBJECT

  enum Step { Introduction,
	      SelectType,
	      SelectFeatures,
	      SelectGestures,
	      FinalDetails,
	      ConfirmDetails,
	      Training,
	      Finished,
	      NoRecognisers,
	      NoFeatures,
	      Closed };

public:
  TrainingAssistant( DigestDbController* controller,
		     JavaVM* jvm,
		     QWidget* parent = 0, Qt::WindowFlags flags = 0 );


protected:
  void resetEvent( VEvent* );
  void trainedRecogsEvent( VTrainedRecogsEvent* );


private slots:
  void on_goBackButton_clicked();
  void on_continueButton_clicked();
  void on_featureListWidget_itemSelectionChanged();
  void on_trainingFeatureListWidget_itemSelectionChanged();

  void gotoStep( TrainingAssistant::Step step );
  void reflectCurrentStep();
  void updateRecogInfoWidget( int recogTypeComboIndex );
  void updateFeatureInfoWidget( const QByteArray& key );

  void gatherDetails();
  void train();

  void onTrainingProgressed( int progress );
  void onCategoryModelDataChanged();


private:
  void initWidgets();
  static void initStaticStrs();

  void worker_itemSelectionChanged( FeaturesListWidget* wCurrent,
				    FeaturesListWidget* wNotCurrent );

  QString detailsAsHtml() const;

  JavaVM* m_jvm;

  Ui::TrainingAssistantForm ui;
  AbstractRecogniser* m_recogniser;
  int m_currentStep;

  CategoryItemModel*   m_categoryModel;
  GestureQueryModel*   m_gestureModel;
  QStandardItemModel*  m_dummyModel;

  QString m_gestureQuery;

  // Details:
  QString            m_recogLabelStr;
  QString            m_recogNotesStr;
  QByteArray         m_recogTypeKey;
  QList<QByteArray>  m_featureKeys;
  QSet<int>          m_gestureIds;
};


#endif  // ! TRAININGASSISTANT_H
