/*  -*- c++ -*-  (for Emacs)
 *
 *  chooser.cpp
 * 
 *  Created by Aidan Lane on Sat Dec 03 2005.
 *  Copyright (c) 2005 CEMA, Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "chooser.h"


Chooser::Chooser( QWidget* parent )
  : QTabBar(parent)
{}


/* Convenience method. */
int Chooser::addTab( const QIcon& icon ) {
  return QTabBar::addTab( icon, QString() );
}


/*!
 * This implementation of this method reduces the size of the tabs to fit the
 * tab icons, without leaving odd spaces on the right-hand size of each
 * (normally used to sep icon from text).
 */
QSize Chooser::tabSizeHint( int index ) const
{
  // TODO: remove the need for the following hack!
  int width = ( QTabBar::tabSizeHint(index).width()
		- ((index == count()-1)
		   ? 12
		   : 14) );
  int height = QTabBar::tabSizeHint(index).height() + 2; // +2 -> VCentre icons
  return QSize( width, height );
}
