/*  -*- c++ -*-  (for Emacs)
 *
 *  chooser.h
 * 
 *  Created by Aidan Lane on Sat Dec 03 2005.
 *  Copyright (c) 2005 CEMA, Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef CHOOSER_H
#define CHOOSER_H


#include <QTabBar>


/*!
 * \brief The Chooser class extends QTabBar to provide a bar that can be used
 *        for choosing tools, views, alignments and so forth, which use symbols
 *        rather than text.
 *
 * The "Chooser" widget is found quite often on Mac OS X.
 *
 * This class reduces the size of the tabs to fit the tab icons, without leaving
 * odd spaces on the right-hand size of each (normally used to sep icon from text).
 */
class Chooser : public QTabBar {

public:
  Chooser( QWidget* parent = 0 );

  int addTab( const QIcon& icon );

protected:
  QSize tabSizeHint( int index ) const;
};


#endif  // ! CHOOSER_H
