/*  -*- c++ -*-  (for Emacs)
 *
 *  headedscrollarea.h
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Aug 04 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

// TODO: come up with a better name! - works also with QListWidget

#ifndef HEADEDSCROLLAREA_H
#define HEADEDSCROLLAREA_H


class QLabel;
class QFont;


/*!
 * Usage: HeadedScrollArea<QListView>, HeadedScrollArea<QListWidget>
 *        HeadedScrollArea<QTextEdit>, HeadedScrollArea<QQTextBrowser>, etc.
 */
template <class extendT>
class HeadedScrollArea : public extendT {

public:
  HeadedScrollArea( QWidget* parent = 0 );
  HeadedScrollArea( const QString& headerText, QWidget* parent = 0 );

  const QString& headerText() const { return m_headerText; }
  void setHeaderText( const QString& text );

  const QFont& headerFont() const { return m_headerFont; }
  void setHeaderFont( const QFont& font );

  /*! Returns the height of the header (in pixels). Defaults to 17. */
  int headerHeight() const { return m_headerHeight; }
  void setHeaderHeight( int height );

  virtual bool event( QEvent* event );


protected:
  virtual void paintHeader();


private:
  void init();

  QString m_headerText;
  QFont   m_headerFont;
  int     m_headerHeight;

  QPixmap m_leftPix;
  QPixmap m_midPix;
  QPixmap m_rightPix;
};


#include "headedscrollarea.ipp"


#endif  // ! HEADEDSCROLLAREA_H
