/*  -*- c++ -*-  (for Emacs)
 *
 *  pixmapsizegrip.cpp
 * 
 *  Created by Aidan Lane on Tue Dec 13 2005.
 *  Copyright (c) 2005 CEMA, Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "pixmapsizegrip.h"

#include <QEvent>
#include <QPainter>


/*!
 * Constructs a pixmap size grip with pixmap \em pixmap and parent object
 * \em parent.
 */
PixmapSizeGrip::PixmapSizeGrip( const QPixmap& pixmap, QWidget* parent )
  : QSizeGrip(parent),
    m_pixmap(pixmap)
{}


/*!
 * Constructs a pixmap size grip with parent object \em parent.
 *
 * As no pixmap is given, the widget's style is used for painting until
 * setPixmap() is called with a non-null pixmap.
 */
PixmapSizeGrip::PixmapSizeGrip( QWidget* parent )
  : QSizeGrip(parent)
{}



/*!
 * Returns the size grip's pixmap.
 */
const QPixmap& PixmapSizeGrip::pixmap() const {
  return m_pixmap;

}


/*!
 * Sets the size grip's pixmap.
 */
void PixmapSizeGrip::setPixmap( const QPixmap& pixmap ) {
  m_pixmap = pixmap;
  update();
}


/*!
 * Prevents QSizeGrip's triangular masking.
 */
bool PixmapSizeGrip::event( QEvent* event ) {
  if ( event->type() == QEvent::Resize )
    return true; // eat event -> prevent masking
  return QSizeGrip::event( event );
}


/*!
 * Paints the the pixmap() if it's not null, otherwise it calls
 * QSizeGrip::paintEvent().
 */
void PixmapSizeGrip::paintEvent( QPaintEvent* event )
{
  if ( m_pixmap.isNull() ) {
    QSizeGrip::paintEvent( event );
  } else {
    QPainter p( this );
    p.drawPixmap( 0, 0, m_pixmap );
  }
}
