/*  -*- c++ -*-  (for Emacs)
 *
 *  pixmapsizegrip.h
 * 
 *  Created by Aidan Lane on Tue Dec 13 2005.
 *  Copyright (c) 2005 CEMA, Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef PIXMAPSIZEGRIP_H
#define PIXMAPSIZEGRIP_H


#include <QSizeGrip>

#include <QPixmap>


/*!
 * \brief The PixmapSizeGrip class extends QSizeGrip to provide a window size
 *        grip that uses a custom pixmap for its representation.
 */
class PixmapSizeGrip : public QSizeGrip {

public:
  PixmapSizeGrip( const QPixmap& pixmap, QWidget* parent );
  PixmapSizeGrip( QWidget* parent );

  const QPixmap& pixmap() const;
  void setPixmap( const QPixmap& pixmap );

protected:
  bool event( QEvent* );
  void paintEvent( QPaintEvent* );
  
private:
  QPixmap m_pixmap;
};


#endif  // ! PIXMAPSIZEGRIP_H
