/*  -*- c++ -*-  (for Emacs)
 *
 *  qwpcombobox.cpp
 * 
 *  Created by Aidan Lane on Wed Jan 04 2006.
 *  Copyright (c) 2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "qwpcombobox.h"


/*!
 * Constructs a combobox with the given \em parent.
 */
QwpComboBox::QwpComboBox( QWidget* parent )
  : QComboBox(parent)
{}


/*! Consistency method. Equalivant to itemData(\em index, Qt::UserRole). */
QVariant QwpComboBox::itemKey( int index ) const {
  return itemData( index );
}

/*! Method required for the reading the currentKey property. */
QVariant QwpComboBox::currentKey() const {
  return itemData( currentIndex() );
}

/*! Method required for the writing the currentKey property. */
void QwpComboBox::setCurrentKey( const QVariant& key ) {
  setCurrentIndex( findData(key) );
}
