/*  -*- c++ -*-  (for Emacs)
 *
 *  qwpcombobox.h
 * 
 *  Created by Aidan Lane on Wed Jan 04 2006.
 *  Copyright (c) 2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef QWPCOMBOBOX_H
#define QWPCOMBOBOX_H


#include <QComboBox>


/*!
 * \brief The QwpComboBox class is a simple extension to QComboBox.
 *        It provides a read-write currentKey property.
 *
 * The reason that this class exists is to allow comboboxes to be used with the
 * SettingsController::bind() feature in a way that is useful.
 *
 * For example, you may have a dynamic combox-box full of SQL drivers, where the
 * "key" is Qt's SQL driver name (e.g. "QPSQL") and the text is a user-friendly
 * version of the driver name (e.g. "PostgreSQL"). In this case, using QComboBox's
 * only read-write "current" property for persistent storage would not only be
 * meaningless by value, but whenever the set of available drivers changes the
 * value could point to different driver items.
 * Thus the currentKey property is used for storage and synchronisation.
 * (Note: The currentText couldn't be used either, as it should be language
 *        dependant and may be changed or other reasons, whereas the stored
 *        value shouldn't).
 *
 * The currentKey uses the Qt::UserRole.
 * Thus, the key and text pair can set using one of the following lines:
 * \code
 * addItem( text, key );
 * insertItem( text, key );
 * \endcode
 */
class QwpComboBox : public QComboBox {

  Q_OBJECT
  Q_PROPERTY( QVariant currentKey READ currentKey WRITE setCurrentKey STORED false )

public:
  QwpComboBox( QWidget* parent = 0 );

  QVariant itemKey( int index ) const;
  QVariant currentKey() const;

public slots:
  void setCurrentKey( const QVariant& key );
};


#endif  // ! QWPCOMBOBOX_H
