/*  -*- c++ -*-  (for Emacs)
 *
 *  qwpdoubleslider.h
 * 
 *  Created by Aidan Lane on Wed Feb 01 2006.
 *  Copyright (c) 2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef QWPDOUBLESLIDER_H
#define QWPDOUBLESLIDER_H


#include <QWidget>
#include <QtDesigner/QDesignerExportWidget>

#include <QPointer>
#include <QSlider>


class QDESIGNER_WIDGET_EXPORT QwpDoubleSlider : public QWidget {

  Q_OBJECT

  // TODO: add RESET methods for the properties for use in Qt Designer

  // Note: The properties are in the order that they appear for QSlider in Qt 4.1

  Q_PROPERTY( double minimum READ minimum WRITE setMinimum )
  Q_PROPERTY( double maximum READ maximum WRITE setMaximum )
  Q_PROPERTY( double singleStep READ singleStep WRITE setSingleStep )
  Q_PROPERTY( double pageStep READ pageStep WRITE setPageStep )
  Q_PROPERTY( double value READ value WRITE setValue )
  Q_PROPERTY( bool sliderDown READ isSliderDown WRITE setSliderDown \
	      DESIGNABLE false )
  Q_PROPERTY( double sliderPosition READ sliderPosition WRITE setSliderPosition )
  Q_PROPERTY( bool tracking READ hasTracking WRITE setTracking )
  Q_PROPERTY( Qt::Orientation orientation READ orientation WRITE setOrientation )
  Q_PROPERTY( bool invertedAppearance READ invertedAppearance \
	      WRITE setInvertedAppearance )
  Q_PROPERTY( bool invertedControls READ invertedControls \
	      WRITE setInvertedControls )
 
  Q_PROPERTY( QSlider::TickPosition tickPosition READ tickPosition \
	      WRITE setTickPosition )
  Q_PROPERTY( double tickInterval READ tickInterval WRITE setTickInterval )

  Q_ENUMS( Qt::Orientation );
  Q_ENUMS( QSlider::TickPosition );


public:
  QwpDoubleSlider( QWidget* parent );
  QwpDoubleSlider( Qt::Orientation orientation, QWidget* parent );

  double value() const;

  double minimum() const;
  double maximum() const;
  void setMinimum( double min );
  void setMaximum( double max );
  void setRange( double min, double max );

  Qt::Orientation orientation() const;

  bool    hasTracking() const;
  bool    invertedAppearance() const;
  bool    invertedControls() const;
  bool    isSliderDown() const;
  double  pageStep() const;
  double  sliderPosition() const;
  double  singleStep() const;
  void    setTracking( bool enable );
  void    setInvertedAppearance( bool enable );
  void    setInvertedControls( bool enable );
  void    setPageStep( double step );
  void    setSliderDown( bool enable );
  void    setSliderPosition( double position );
  void    setSingleStep( double step );

  double  tickInterval() const;
  void setTickInterval( double interval );

  QSlider::TickPosition tickPosition() const;
  void setTickPosition( QSlider::TickPosition position );

  void triggerAction( QSlider::SliderAction action );

  QSize sizeHint() const;


signals:
  void actionTriggered( int action );
  void rangeChanged( double min, double max );
  void sliderMoved( double value );
  void sliderPressed();
  void sliderReleased();
  void valueChanged( double value );
  


public slots:
  void setOrientation( Qt::Orientation orientation );
  void setValue( double value );


protected:
  QSlider* slider() const;

  double sliderValueToDouble( int value ) const;
  int    doubleToSliderValue( double value ) const;

  void resizeEvent( QResizeEvent* event );


private slots:
  // actionTriggered, sliderPressed and sliderReleased are re-sent directly
  // rangeChanged isn't needed, as the internal slider's range never changes
  void onSliderMoved( int value );
  void onSliderValueChanged( int value );


private:
  void init();

  QPointer<QSlider> m_slider;

  double m_value;
  double m_min;
  double m_max;
  double m_pageStep;
  double m_singleStep;
  double m_sliderPosition;
  double m_tickInterval;
};


/*!
  \brief The QwpHDoubleSlider widget provides a horizontal slider.

  This class is purely for convenience - aimed at use in Qt Designer.
*/
class QDESIGNER_WIDGET_EXPORT QwpHDoubleSlider : public QwpDoubleSlider {
  Q_OBJECT
public:
  QwpHDoubleSlider( QWidget* parent )
    : QwpDoubleSlider(Qt::Horizontal, parent) {}
};


/*!
  \brief The QwpHDoubleSlider widget provides a vertical slider.

  This class is purely for convenience - aimed at use in Qt Designer.
*/
class QDESIGNER_WIDGET_EXPORT QwpVDoubleSlider : public QwpDoubleSlider {
  Q_OBJECT
public:
  QwpVDoubleSlider( QWidget* parent )
    : QwpDoubleSlider(Qt::Vertical, parent) {}
};


#endif  // ! QWPDOUBLESLIDER_H
