/*  -*- c++ -*-  (for Emacs)
 *
 *  searchwidget.h
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Aug 04 2005.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef SEARCHWIDGET_H
#define SEARCHWIDGET_H


#include <QWidget>

#include <QFlags>
#include <QPixmap>

class QLineEdit;
class QMenu;

class SimpleIconToolButton;


class SearchWidget : public QWidget {

  Q_OBJECT

public:
  enum SearchTrigger {
    NoTriggers             = 0x0,
    OnReturnPressed        = 0x1,
    OnTextEdited           = 0x2,
    OnMenuActionTriggered  = 0x4,
    AllTriggers = OnReturnPressed | OnTextEdited | OnMenuActionTriggered
  };
  Q_DECLARE_FLAGS( SearchTriggers, SearchTrigger ); // typesafe flags

  SearchWidget( QWidget* parent = 0 );

  QMenu* menu() const;
  void setMenu( QMenu* menu );

  SearchTriggers searchTriggers() const;
  void setSearchTriggers( SearchTriggers triggers );


signals:
  void beginSearch( const QString& text );
  void endSearch();


public slots:
  virtual void search();
  virtual void clear();
  virtual void setText( const QString& text, bool startSearch=true );


protected:
  virtual void paintEvent( QPaintEvent* );

  QLineEdit* lineEdit() const;
  SimpleIconToolButton* searchButton() const;
  SimpleIconToolButton* clearButton() const;


private slots:
  void onReturnPressed();
  void onTextEdited( const QString& text );


private:
  QLineEdit* m_lineEdit;
  SimpleIconToolButton* m_searchButton;
  SimpleIconToolButton* m_clearButton;
  SearchTriggers m_searchTriggers;

  QPixmap m_leftCapPixmap;
  QPixmap m_middleTilePixmap;
  QPixmap m_rightCapPixmap;
};

Q_DECLARE_OPERATORS_FOR_FLAGS( SearchWidget::SearchTriggers );


#endif  // ! SEARCHWIDGET_H
