/*  -*- c++ -*-  (for Emacs)
 *
 *  simpleiconpushbutton.h
 *
 *  Created by Aidan Lane on Thu Apr 14 2005.
 *  Copyright (c) 2005 CEMA, Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 */


#ifndef SIMPLEICONPUSHBUTTON_H
#define SIMPLEICONPUSHBUTTON_H


#include <QPushButton>
#include "simpleiconbutton.h"


/*!
 * Convenience class.
 *
 * Provides the same constructors as QPushButton.
 */
class SimpleIconPushButton : public SimpleIconButton<QPushButton> {

public:
  SimpleIconPushButton( QWidget* parent = 0 )
    : SimpleIconButton<QPushButton>(parent) {}

  SimpleIconPushButton( const QString& text, QWidget* parent = 0 ) 
    : SimpleIconButton<QPushButton>(parent)
  {
    setText( text );
  }

  SimpleIconPushButton( const QIcon& icon, const QString& text, QWidget* parent = 0 ) 
    : SimpleIconButton<QPushButton>(parent)
  {
    setIcon( icon );
    setText( text );
  }

  virtual ~SimpleIconPushButton() {}
};


#endif // ! SIMPLEICONPUSHBUTTON_H
