/*  -*- c++ -*-  (for Emacs)
 *
 *  plugin.cpp
 * 
 *  Created by Aidan Lane on Wed Feb 01 2006.
 *  Copyright (c) 2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include <QtDesigner/QDesignerContainerExtension>
#include <QtDesigner/QDesignerCustomWidgetInterface>

#include <QtCore/qplugin.h>
#include <QtGui/QIcon>

//#include "qwpcombobox.h"
#include "qwpdoubleslider.h"



class QDesignerFormEditorInterface;


class WidgetPackWidgetPlugin : public QDesignerCustomWidgetInterface
{
  Q_INTERFACES(QDesignerCustomWidgetInterface)

public:
  WidgetPackWidgetPlugin() : m_initialized(false) { }
  bool isContainer() const { return false; }
  bool isInitialized() const { return m_initialized; }
  QIcon icon() const { return QIcon(); }
  QString codeTemplate() const { return QString(); }
  QString whatsThis() const { return QString(); }
  QString toolTip() const { return QString(); }
  QString group() const { return "Widget Pack"; }
  void initialize(QDesignerFormEditorInterface *)
  {
    if (m_initialized)
      return;
    m_initialized = true;
  }
private:
  bool m_initialized;
};


class QwpHDoubleSliderPlugin : public QObject, public WidgetPackWidgetPlugin
{
  Q_OBJECT
public:
  QwpHDoubleSliderPlugin(QObject *parent = 0) : QObject(parent) { }

  QString includeFile() const { return "qwpdoubleslider.h"; }
  QString name() const { return "QwpHDoubleSlider"; } // WARNING: this MUST match the class's name, else there will be issues!!! (e.g. Qt Designer preview will be wrong).
#if 0
  QString domXml() const
  {
    return ( "<widget class=\"QwpDoubleSlider\" name=\"doubleSlider\">\n"
	     " <property name=\"geometry\">\n"
	     "  <rect>\n"
	     "   <x>0</x>\n"
	     "   <y>0</y>\n"
	     "   <width>300</width>\n"
	     "   <height>40</height>\n"
	     "  </rect>\n"
	     " </property>\n"
	     " <property name=\"value\">\n"
	     "  <number>0.0</number>\n"
	     " </property>\n"
	     " <property name=\"minimum\">\n"
	     "  <number>0.0</number>\n"
	     " </property>\n"
	     " <property name=\"maximum\">\n"
	     "  <number>100.0</number>\n"
	     " </property>\n"
	     "</widget>\n" );
  }
#endif
  QWidget *createWidget(QWidget *parent)
  {
    QwpDoubleSlider *slider = new QwpHDoubleSlider( parent );
    return slider;
  }
};


class QwpVDoubleSliderPlugin : public QObject, public WidgetPackWidgetPlugin
{
  Q_OBJECT
public:
  QwpVDoubleSliderPlugin(QObject *parent = 0) : QObject(parent) { }

  QString includeFile() const { return "qwpdoubleslider.h"; }
  QString name() const { return "QwpVDoubleSlider"; } // WARNING: this MUST match the class's name, else there will be issues!!! (e.g. Qt Designer preview will be wrong).

  QWidget *createWidget(QWidget *parent)
  {
    QwpDoubleSlider *slider = new QwpVDoubleSlider( parent );
    return slider;
  }

};


class WidgetPackPlugin : public QObject, public QDesignerCustomWidgetCollectionInterface
{
  Q_OBJECT
  Q_INTERFACES(QDesignerCustomWidgetCollectionInterface)

public:
  QList<QDesignerCustomWidgetInterface*> customWidgets() const
  {
    QList<QDesignerCustomWidgetInterface *> plugins;
    plugins
      << new QwpHDoubleSliderPlugin 
      << new QwpVDoubleSliderPlugin;
    return plugins;
  }
};


#include "widgetpackplugin.moc"

Q_EXPORT_PLUGIN2( WidgetPackPlugin, WidgetPackPlugin )
