/*  -*- c++ -*-  (for Emacs)
 *
 *  digestsettings.h
 * 
 *  Created by Aidan Lane on Wed Feb 03 2006.
 *  Copyright (c) 2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef DIGESTSETTINGS_H
#define DIGESTSETTINGS_H


#include <QString>


namespace DigestSettings {
  static const QString inputStrokeWidthKey         = "Input/StrokeWidth";
  static const QString inputAnimationSpeedKey      = "Input/AnimationSpeed";
  static const QString inputMultiStrokeTimeoutKey  = "Input/MultiStrokeTimout";
  static const QString inputMouseAsPenKey          = "Input/MouseAsPen";
  static const QString inputRecordHiResKey         = "Input/RecordHiRes";

  static const QString dbTypeKey                   = "Db/Type";
  static const QString dbIsRemoteKey               = "Db/IsRemote";
  static const QString dbFilenameKey               = "Db/Filename";
  static const QString dbNameKey                   = "Db/Name";
  static const QString dbHostnameKey               = "Db/Hostname";
  static const QString dbPortKey                   = "Db/Port";
  static const QString dbUsernameKey               = "Db/Username";

  // TODO: move the following into the Gesture Browser component
  static const QString gestureBrowserThumbnailSizeKey      = "GestureBrowser/ThumbnailSize";
  static const QString gestureBrowserTopSplitterStateKey   = "GestureBrowser/TopSplitterState";

  // TODO: move the following into the Experiment Browser component
  static const QString exprBrowserTopSplitterStateKey      = "ExperimentBrowser/TopSplitterState";
  static const QString exprBrowserDetailsSplitterStateKey  = "ExperimentBrowser/DetailsSplitterState";
  static const QString exprBrowserResultsFilterKey         = "ExperimentBrowser/ResultsFilter";
  static const QString exprBrowserShowTestGestureKey       = "ExperimentBrowser/ShowTestGesture";
  static const QString exprBrowserShowTestClassKey         = "ExperimentBrowser/ShowTestClass";
  static const QString exprBrowserShowResultClassKey       = "ExperimentBrowser/ShowResultClass";
  static const QString exprBrowserShowResultProbKey        = "ExperimentBrowser/ShowResultProb";
  static const QString exprBrowserShowExprIdKey            = "ExperimentBrowser/ShowExprId";
  static const QString exprBrowserShowExprLabelKey         = "ExperimentBrowser/ShowExprLabel";
  static const QString exprBrowserShowExprDateKey          = "ExperimentBrowser/ShowExprDate";
  static const QString exprBrowserShowExprOthersKey        = "ExperimentBrowser/ShowExprOthers";
  static const QString exprBrowserShowExprRecogKey         = "ExperimentBrowser/ShowExprRecog";
  static const QString exprBrowserShowGenIsCorrectKey      = "ExperimentBrowser/ShowGenIsCorrect";
};



#endif  // ! DIGESTSETTINGS_H
