/*  -*- c++ -*-  (for Emacs)
 *
 *  extrafeatures.h
 *  Digest
 * 
 *  Created by Adrian Bickerstaffe on 10/5/2006.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef EXTRAFEATURES_H
#define EXTRAFEATURES_H

#include "stlfeatureinterface.h"

///////////////////////

// Class to represent a vertex of a convex hull.
class hull_vertex
{
public:
	hull_vertex(void);
	hull_vertex(const float &, const float &);
	
	float x, y;
}; 

bool vertex_x_compare(const hull_vertex &, const hull_vertex &);
bool vertex_y_compare(const hull_vertex &, const hull_vertex &);

// Class to represent a convex hull which is to be formed around
// an StlStroke.
class convex_hull
{
public:
	convex_hull(const StlStroke &);
	~convex_hull(void);	
	
	double get_perimeter_length(void) const;
	double get_area(void) const;
	void print(void) const;
	
private:
	int num_vertices;
	hull_vertex *hull_vertices, *stroke_vertices;
	double perimeter_length, area;
	
	int create_hull(hull_vertex*, int, hull_vertex*);	
	float is_left(hull_vertex, hull_vertex, hull_vertex);
	
	double calc_perimeter_length(void);
	double calc_area(void);
};

////////////////////

#define DECLARE_STL_FEATURE_CALCVALUE_METHODS									\
	static StlFeatureResultT													\
	classCalcValue(const StlStroke & stroke, bool* ok = 0);						\
	StlFeatureResultT calcValue(const StlStroke & stroke, bool* ok = 0) const	\
	{ return classCalcValue(stroke, ok); }
  
class abs_coord_change : public StlFeatureInterface
{
public:
	DECLARE_STL_FEATURE_KEY("abs_coord_change");
	DECLARE_STL_FEATURE_TITLE("Ratio of absolute x, y coordinate change");
	DECLARE_STL_FEATURE_DESCRIPTION_METHODS;
	DECLARE_STL_FEATURE_CALCVALUE_METHODS;
};

class path_ratio : public StlFeatureInterface
{
public:
	DECLARE_STL_FEATURE_KEY("path_ratio");
	DECLARE_STL_FEATURE_TITLE("Ratio of stroke length to convex hull perimeter");
	DECLARE_STL_FEATURE_DESCRIPTION_METHODS;
	DECLARE_STL_FEATURE_CALCVALUE_METHODS;
};

class area_ratio : public StlFeatureInterface
{
public:
	DECLARE_STL_FEATURE_KEY("area_ratio");
	DECLARE_STL_FEATURE_TITLE("Ratio of stroke length to bounding box area");
	DECLARE_STL_FEATURE_DESCRIPTION_METHODS;
	DECLARE_STL_FEATURE_CALCVALUE_METHODS;
};

class general_density : public StlFeatureInterface
{
public:
	DECLARE_STL_FEATURE_KEY("general_density");
	DECLARE_STL_FEATURE_TITLE("Ratio of stroke length to bounding box area");
	DECLARE_STL_FEATURE_DESCRIPTION_METHODS;
	DECLARE_STL_FEATURE_CALCVALUE_METHODS;
};

class density_spread : public StlFeatureInterface
{
public:
  DECLARE_STL_FEATURE_KEY("density_spread");
  DECLARE_STL_FEATURE_TITLE("The type of vertical point density spread");
  DECLARE_STL_FEATURE_DESCRIPTION_METHODS;
  DECLARE_STL_FEATURE_CALCVALUE_METHODS;
};

class relative_length : public StlFeatureInterface
{
public:
	DECLARE_STL_FEATURE_KEY("relative_length");
	DECLARE_STL_FEATURE_TITLE("Ratio of stroke length to distance between stroke endpoints");
	DECLARE_STL_FEATURE_DESCRIPTION_METHODS;
	DECLARE_STL_FEATURE_CALCVALUE_METHODS;
};

class start_quadrant : public StlFeatureInterface
{
public:
	DECLARE_STL_FEATURE_KEY("start_quadrant");
	DECLARE_STL_FEATURE_TITLE("The quadrant of the bounding box in which the stroke begins");
	DECLARE_STL_FEATURE_DESCRIPTION_METHODS;
	DECLARE_STL_FEATURE_CALCVALUE_METHODS;
};

class end_quadrant : public StlFeatureInterface
{
public:
	DECLARE_STL_FEATURE_KEY("end_quadrant");
	DECLARE_STL_FEATURE_TITLE("The quadrant of the bounding box in which the stroke ends");
	DECLARE_STL_FEATURE_DESCRIPTION_METHODS;
	DECLARE_STL_FEATURE_CALCVALUE_METHODS;
};

class num_cusps : public StlFeatureInterface
{
public:
	DECLARE_STL_FEATURE_KEY("num_cusps");
	DECLARE_STL_FEATURE_TITLE("The number of cusps");
	DECLARE_STL_FEATURE_DESCRIPTION_METHODS;
	DECLARE_STL_FEATURE_CALCVALUE_METHODS;
};

#endif  // ! EXTRAFEATURES_H
