/*  -*- c++ -*-  (for Emacs)
 *
 *  extrafeaturesplugin.cpp
 * 
 *  Created by Adrian Bickerstaffe on 10/5/2006.
 *  Copyright (c) 2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "extrafeaturesplugin.h"
#include "extrafeatures.h"

#include <locale>

using namespace std;

EXPORT_STL_FEATURE_FACTORY_PLUGIN(ExtraFeaturesPlugin);


#define RETURN_VALUE( VALUE, METHOD, PRE, POST, DEFAULT  ) {	\
	if ( VALUE == abs_coord_change::METHOD )					\
		return PRE abs_coord_change POST;						\
	else if ( VALUE == path_ratio::METHOD )						\
		return PRE path_ratio POST;								\
	else if ( VALUE == area_ratio::METHOD )						\
		return PRE area_ratio POST;								\
	else if ( VALUE == general_density::METHOD )				\
		return PRE general_density POST;						\
	else if ( VALUE == density_spread::METHOD )					\
		return PRE density_spread POST;							\
	else if ( VALUE == relative_length::METHOD )				\
		return PRE relative_length POST;						\
	else if ( VALUE == start_quadrant::METHOD )					\
		return PRE start_quadrant POST;							\
	else if ( VALUE == end_quadrant::METHOD )					\
		return PRE end_quadrant POST;							\
	else if ( VALUE == num_cusps::METHOD )						\
		return PRE num_cusps POST;								\
    return DEFAULT;												\
  }


// Setup and return the feature keys.
std::set<std::string> ExtraFeaturesPlugin::keys(void)
{
	set<string> the_keys;

	the_keys.insert(abs_coord_change::classKey());
	the_keys.insert(path_ratio::classKey());
	the_keys.insert(area_ratio::classKey());
	the_keys.insert(general_density::classKey());
	the_keys.insert(density_spread::classKey());
	the_keys.insert(relative_length::classKey());
	the_keys.insert(start_quadrant::classKey());
	the_keys.insert(end_quadrant::classKey());
	the_keys.insert(num_cusps::classKey());
  
	return the_keys;
}

StlFeatureInterface* ExtraFeaturesPlugin::create(const std::string & key)
{
	// TODO: compare 'key' and 'classKey()' in lower case
	RETURN_VALUE(key, classKey(), new, (), 0);
}

string ExtraFeaturesPlugin::title(const std::string & key)
{
	// TODO: compare 'key' and 'classKey()' in lower case
	RETURN_VALUE(key, classKey(), , ::classTitle(), string());
}

string ExtraFeaturesPlugin::description(const std::string & key)
{
	// Warning: The descriptions may be long and there may be many of them,
	//          hence, its probably best that we don't cache them.
	// TODO: compare 'key' and 'classKey()' in lower case
	RETURN_VALUE(key, classKey(), , ::classDescription(), string());
}
