/*
 *  JRecogniserLinear.java
 *  Digest
 * 
 *  Created by Aidan Lane on Sun Oct 30 2005.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

import java.util.Vector;


public class JavaMultiRecogniser implements JavaRecogniserInterface {

    public static String classKey() {
	return "javamulti";
    }
    public String key() { return classKey(); }

    public static String classTitle() {
	return "Linear Recogniser (Java version)";
    }
    public String title() { return classTitle(); }

    public static String classDescription() {
	return ("<B>Simple Linear Recogniser</B><BR><BR>"
		+ "Although it requires 2 or more features to work, "
		+ "there are no restrictions on which features can or "
		+ "cannot be used.<BR><BR>"
		+ "As noted above, this recogniser was written in "
		+ "<EM>Java</EM>.");
    }
    public String description() { return classDescription(); }

    public boolean initTraining() {
	System.out.println("JAVA: initTraining");
	return true;
    }

    public boolean examineSample( Vector featureVec ) {
	System.out.println("JAVA: examineSample");
	return true;
    }

    public boolean finaliseTraining() {
	System.out.println("JAVA: finaliseTraining");
	return true;
    }

    public boolean writeModelFile( String fileName ) {
	System.out.println("JAVA: writeModelFile: " + fileName);
	return true;
    }

    public boolean readModelFile( String fileName ) {
	System.out.println("JAVA: readModelFile: " + fileName);
	return true;
    }

    public void flatten() {
	System.out.println("JAVA: flatten");
    }

    public void classify() {
	System.out.println("JAVA: classify");
    }
}
