// -*- c++ -*-  (for Emacs)
// CREATED: Jul 13, 2005

#ifndef BOBMATRIX_H
#define BOBMATRIX_H

#include <cmath>


/*!
 * This method is used to get the inverse of a order*order matrix.
 *
 * It actually came from from Nate Robins' OpenGL Tutors.<br>
 * I contacted him via email (nate@pobox.com) on Sunday 25, January 2004
 * and got the OK from him to use it before I went ahead and used it.
 *
 * Beginning of the source code file projection.c:
 * \code
 *     projection.c
 *     Nate Robins, 1997
 *
 *     Tool for teaching about OpenGL projections.
 * \endcode
 */
template <class Type>
bool invert( const Type* src, Type* inverse, int order )
{
  double t;
  int i, j, k, swap;
  Type tmp[order][order];
 
  Q_ASSERT( src != 0 );
  Q_ASSERT( inverse != 0 );
   
  for (i = 0; i < order; i++) {
    for (j = 0; j < order; j++) {
      tmp[i][j] = src[i*order+j];
      
      // set identity matrix to the inverse matrix
      inverse[i*order+j] = ( i==j ? 1 : 0 );
    }
  }
    
  for (i = 0; i < order; i++) {
    /* look for largest element in column. */
    swap = i;
    for (j = i + 1; j < order; j++) {
      if (fabs(tmp[j][i]) > fabs(tmp[i][i])) {
	swap = j;
      }
    }
        
    if (swap != i) {
      /* swap rows. */
      for (k = 0; k < order; k++) {
	t = tmp[i][k];
	tmp[i][k] = tmp[swap][k];
	tmp[swap][k] = t;
                
	t = inverse[i*order+k];
	inverse[i*order+k] = inverse[swap*order+k];
	inverse[swap*order+k] = t;
      }
    }
        
    if (tmp[i][i] == 0) {
      /* no non-zero pivot.  the matrix is singular, which
	 shouldn't happen.  This means the user gave us a bad
	 matrix. */
      Q_ASSERT( !"no non-zero pivot.  the matrix is singular" );
      return false;
    }
        
    t = tmp[i][i];
    for (k = 0; k < order; k++) {
      tmp[i][k] /= t;
      inverse[i*order+k] /= t;
    }
    for (j = 0; j < order; j++) {
      if (j != i) {
	t = tmp[j][i];
	for (k = 0; k < order; k++) {
	  tmp[j][k] -= tmp[i][k]*t;
	  inverse[j*order+k] -= inverse[i*order+k]*t;
	}
      }
    }
  }
  return true;
}



#endif  // ! BOBMATRIX_H
