/*  -*- c++ -*-  (for Emacs)
 *
 *  linearplugin.cpp
 *  Digest
 * 
 *  Created by Aidan Lane on Wed Jan 18 2006.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "linearplugin.h"

#include "linearrecogniser.h"

using namespace std;

EXPORT_STL_RECOGNISER_FACTORY_PLUGIN( LinearPlugin );


set<string> LinearPlugin::keys() {
  set<string> keyset;
  keyset.insert( LinearRecogniser::classKey() );
  return keyset;
}

StlRecogniserInterface* LinearPlugin::create( const std::string& key ) {
  return ( key == LinearRecogniser::classKey()
	   ? new LinearRecogniser()
	   : 0 );
}

string LinearPlugin::title( const std::string& key ) {
  return ( key == LinearRecogniser::classKey()
	   ? LinearRecogniser::classTitle()
	   : string() );
}

string LinearPlugin::description( const std::string& key ) {
  return ( key == LinearRecogniser::classKey()
	   ? LinearRecogniser::classDescription()
	   : string() );
}
