/*  -*- c++ -*-  (for Emacs)
 *
 *  linearrecogniser.cpp
 *  Digest
 * 
 *  Created by Aidan Lane on Tue Jan 17 2006.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "linearrecogniser.h"

#include <cassert>
#include <iostream> // TODO: remove me


LinearRecogniser::LinearRecogniser() {
  cout << "LinearRecogniser created" << endl;
}

LinearRecogniser::~LinearRecogniser() {
  cout << "LinearRecogniser destroyed" << endl;
}


const map<string, string>& LinearRecogniser::defaultParams() const {
  static map<string, string> p;
  cout << "LinearRecogniser::defaultParams" << endl;
  return p;
}


bool LinearRecogniser::initTraining( const list<string>& featureKeys,
				     const map<string, string>& /*params*/ ) {
  cout << "LinearRecogniser::initTraining using "
       << featureKeys.size() << " features" << endl;
  return true;
}

bool LinearRecogniser::examineSample( const StlFeatureVec& /*featureVec*/,
				      const set<int>& /*classes*/ ) {
  cout << "LinearRecogniser::examineSample" << endl;
  return true;
}

bool LinearRecogniser::finaliseTraining() {
  cout << "LinearRecogniser::finaliseTraining" << endl;
  return true;
}

bool LinearRecogniser::writeModelFile( const string& fileName ) {
  cout << "LinearRecogniser::writeModelFile: " << fileName << endl;
  return true;
}

bool LinearRecogniser::readModelFile( const string& fileName ) {
  cout << "LinearRecogniser::readModelFile: " << fileName << endl;
  return true;
}

StlStroke LinearRecogniser::flatten( const StlStrokeList& strokes ) {
  cout << "LinearRecogniser::flatten" << endl;
  return StlRecogniserInterface::flatten( strokes ); // use default impl
}


StlClassProbabilities
LinearRecogniser::classify( const StlFeatureVec& featureVec )
{
  cout << "LinearRecogniser::classify" << endl;

  StlClassProbabilities results;
  StlClassProbabilityT resultsSum = 0.0;
  StlClassProbabilityT lowestNegValue = 0.0; // init this to 0 -> no neg value
  unsigned numFeatures = featureVec.size();

  // Step 1 - Fill the results hash with our internal scores
  map< int, vector<WeightT> >::const_iterator it = m_classWeights.begin();
  while ( it != m_classWeights.end() )
    {
      const vector<WeightT>& w = (*it).second;
      assert( w.size() == numFeatures );

      StlClassProbabilityT v = w[0];
      for ( unsigned i=0; i < numFeatures; ++i )
	v += w[i+1] * featureVec[i]; // note: using w_1 to w_F -> w[i+1]

      results[(*it).first] = v;
      resultsSum += v;

      if ( v < lowestNegValue ) lowestNegValue = v;

      ++it;
    }

  // Step 2 - Turn the internal scores in the results hash in to confience values
  resultsSum -= lowestNegValue * (StlClassProbabilityT)results.size();
  if ( resultsSum != 0.0 ) { // TODO: use fabs() ?
    for ( unsigned i=0; i < results.size(); ++i )
      results[i] = (results[i]-lowestNegValue) / resultsSum;
  }

  return results;
}
