/*  -*- c++ -*-  (for Emacs)
 *
 *  linearrecogniser.h
 *  Digest
 * 
 *  Created by Aidan Lane on Tue Jan 17 2006.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef LINEARRECOGNISER_H
#define LINEARRECOGNISER_H


#include "stlrecogniserinterface.h"

#include <map>
#include <vector>

using namespace std;


class LinearRecogniser : public StlRecogniserInterface {

  typedef double WeightT;

public:
  LinearRecogniser();
  ~LinearRecogniser();

  DECLARE_STL_RECOGNISER_KEY( "linear" );
  DECLARE_STL_RECOGNISER_TITLE( "Linear Recogniser" );
  DECLARE_STL_RECOGNISER_DESCRIPTION( "<B>Simple Linear Recogniser</B><BR><BR>"
				      "Although it requires 2 or more features "
				      "to work, there are no restrictions on "
				      "which features can or cannot be used." );

  const map<string, string>& defaultParams() const;

  bool initTraining( const list<string>& featureKeys,
		     const map<string, string>& params );
  bool examineSample( const StlFeatureVec& featureVec,
		      const set<int>& classes );
  bool finaliseTraining();

  bool writeModelFile( const string& fileName );
  bool readModelFile( const string& fileName );

  StlStroke flatten( const StlStrokeList& strokes );
  StlClassProbabilities classify( const StlFeatureVec& featureVec );

private:
  map< int, vector<WeightT> > m_classWeights;
};


#endif  // ! LINEARRECOGNISER_H
