/*  -*- c++ -*-  (for Emacs)
 *
 *  linearrecogniser.h
 *  Digest
 * 
 *  Created by Aidan Lane on Mon Jul 11 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef LINEARRECOGNISER_H
#define LINEARRECOGNISER_H 


#include "abstractrecogniser.h"


#include <QHash>
#include <QVector>

class AbstractFeature;


class LinearRecogniser : public AbstractRecogniser {

  typedef double WeightT; // TODO: share this with AbstractRecogniserTrainer

public:
  LinearRecogniser( JavaVM* jvm );

  DECLARE_CLASS_KEY( "linear" );
  DECLARE_CLASS_TITLE( "Linear Recogniser" );
  DECLARE_CLASS_DESCRIPTION( "<B>Simple Linear Recogniser</B><BR><BR>"
			    "Although it requires 2 or more features to work, "
			    "there are no restrictions on which features can or "
			    "cannot be used." );


protected:
  bool readModelFile( const QString& fileName );

  ClassProbabilities classifyGestureImp( const DGestureRecord& gesture,
				     const QVector<FeatureResultT>& featureVec );


private:
  QHash< int, QVector<WeightT> > m_classWeights;
};


#endif  // ! LINEARRECOGNISER_H
