/*  -*- c++ -*-  (for Emacs)
 *
 *  linearrecognisertrainer.h
 *  Digest
 * 
 *  Created by Aidan Lane on Mon Jul 11 2005.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef LINEARRECOGNISERTRAINER_H
#define LINEARRECOGNISERTRAINER_H


#include "abstractrecognisertrainer.h"

#include "linearrecogniser.h"

#include <QHash>
#include <QVector>


class LinearRecogniserTrainer : public AbstractRecogniserTrainer {

  typedef double WeightT;

public:
  LinearRecogniserTrainer( JavaVM* jvm,
			   DigestDbModel* digestDbModel,
			   QObject* parent = 0 );

  // Define the key and the title using LinearRecogniser, ensuring sync:
  DECLARE_CLASS_KEY( LinearRecogniser::classKey() );
  DECLARE_CLASS_TITLE_NONTR( LinearRecogniser::classTitle() );
  DECLARE_CLASS_DESCRIPTION_NONTR( LinearRecogniser::classDescription() );


protected:
  bool prepareForTraining();
  bool examineSample( const DGestureRecord& sample,
		       const QVector<FeatureResultT>& featureVec );
  bool finalizeTraining();
  bool writeModelFile( const QString& fileName );


private:
  /* Class -> Sample -> Feature result vector
   *
   * Datatype rational:
   *  - QHash for class      : class IDs are not sequential
   *  - QList for sample    : sequential of UNknown number for each class
   *  - QVector for results  : sequential and length known (==|featureKeys|)
   *
   * Note: It's better to use QVector vs. QList if the length is known in
   *       advance and will remain static in length, where all the memory
   *       will be allocated once (and immediately).
   */
  QHash<int, QList< QVector<FeatureResultT> > > m_classSampleResults;
  int c_numFeatures;  // cached value

  QHash< int, QVector<WeightT> > m_classWeights;
};


#endif  // ! LINEARRECOGNISERTRAINER_H
