/*  -*- c++ -*-  (for Emacs)
 *
 *  standardfeaturesplugin.cpp
 * 
 *  Created by Aidan Lane on Sun Apr 30 2006.
 *  Copyright (c) 2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "standardfeaturesplugin.h"

#include "standardfeatures.h"

#include <locale>

using namespace std;

EXPORT_STL_FEATURE_FACTORY_PLUGIN( StandardFeaturesPlugin );


#define RETURN_VALUE( VALUE, METHOD, PRE, POST, DEFAULT  ) {	\
    if ( VALUE == CosInitAngleFeature::METHOD )					\
      return PRE CosInitAngleFeature POST;						\
    else if ( VALUE == SinInitAngleFeature::METHOD )			\
      return PRE SinInitAngleFeature POST;						\
    else if ( VALUE == BBoxDiagLengthFeature::METHOD )			\
      return PRE BBoxDiagLengthFeature POST;					\
    else if ( VALUE == BBoxDiagAngleFeature::METHOD )			\
      return PRE BBoxDiagAngleFeature POST;						\
    else if ( VALUE == FirstToLastDistFeature::METHOD )			\
      return PRE FirstToLastDistFeature POST;					\
    else if ( VALUE == CosFirstToLastAngleFeature::METHOD )		\
      return PRE CosFirstToLastAngleFeature POST;				\
    else if ( VALUE == SinFirstToLastAngleFeature::METHOD )		\
      return PRE SinFirstToLastAngleFeature POST;				\
    else if ( VALUE == TotalGestureLengthFeature::METHOD )		\
      return PRE TotalGestureLengthFeature POST;				\
    else if ( VALUE == TotalAngleTraversedFeature::METHOD )		\
      return PRE TotalAngleTraversedFeature POST;				\
    else if ( VALUE == TotalAbsAngleTraversedFeature::METHOD )	\
      return PRE TotalAbsAngleTraversedFeature POST;			\
    else if ( VALUE == TotalSqrdAngleTraversedFeature::METHOD )	\
      return PRE TotalSqrdAngleTraversedFeature POST;			\
    else if ( VALUE == MaxSqrdSpeedFeature::METHOD )			\
      return PRE MaxSqrdSpeedFeature POST;						\
    else if ( VALUE == DurationFeature::METHOD )				\
      return PRE DurationFeature POST;							\
    return DEFAULT;												\
}


std::set<std::string> StandardFeaturesPlugin::keys()
{
  set<string> ret;
  ret.insert( CosInitAngleFeature::classKey() );
  ret.insert( SinInitAngleFeature::classKey() );
  ret.insert( BBoxDiagLengthFeature::classKey() );
  ret.insert( BBoxDiagAngleFeature::classKey() );
  ret.insert( FirstToLastDistFeature::classKey() );
  ret.insert( CosFirstToLastAngleFeature::classKey() );
  ret.insert( SinFirstToLastAngleFeature::classKey() );
  ret.insert( TotalGestureLengthFeature::classKey() );
  ret.insert( TotalAngleTraversedFeature::classKey() );
  ret.insert( TotalAbsAngleTraversedFeature::classKey() );
  ret.insert( TotalSqrdAngleTraversedFeature::classKey() );
  ret.insert( MaxSqrdSpeedFeature::classKey() );
  ret.insert( DurationFeature::classKey() );
  return ret;
}

StlFeatureInterface* StandardFeaturesPlugin::create( const std::string& key ) {
  // TODO: compare 'key' and 'classKey()' in lower case
  RETURN_VALUE( key, classKey(), new, (), 0 );
}

string StandardFeaturesPlugin::title( const std::string& key ) {
  // TODO: compare 'key' and 'classKey()' in lower case
  RETURN_VALUE( key, classKey(), , ::classTitle(), string() );
}

string StandardFeaturesPlugin::description( const std::string& key ) {
  // Warning: The descriptions may be long and there may be many of them,
  //          hence, its probably best that we don't cache them.
  // TODO: compare 'key' and 'classKey()' in lower case
  RETURN_VALUE( key, classKey(), , ::classDescription(), string() );
}
