/*  -*- c++ -*-  (for Emacs)
 *
 *  stlfeature.h
 * 
 *  Created by Aidan Lane on Sun Apr 30 2006.
 *  Copyright (c) 2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef STLFEATURE_H
#define STLFEATURE_H


#include "stlfeatureinterface.h"

using namespace std;


class StlFeature : public StlFeatureInterface {

public:
  StlFeature();
  ~StlFeature();

  DECLARE_STL_FEATURE_KEY( "stlfeature" );
  DECLARE_STL_FEATURE_TITLE( "STL C++ Feature" );
  DECLARE_STL_FEATURE_DESCRIPTION( "This is not a real feature, "
				   "just a \"skeleton\" example of one.");

  StlFeatureResultT calcValue( const StlStroke& stroke, bool* ok = 0 ) const;
};


#endif  // ! STLFEATURE_H
