/*  -*- c++ -*-  (for Emacs)
 *
 *  stlfeatureplugin.h
 * 
 *  Created by Aidan Lane on Sun Apr 30 2006.
 *  Copyright (c) 2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef STLFEATUREPLUGIN_H
#define STLFEATUREPLUGIN_H


#include "stlfeaturefactoryplugin.h"


class StlFeaturePlugin : public StlFeatureFactoryPlugin {

public:
  std::set<std::string> keys();
  StlFeatureInterface* create( const std::string& key );

  std::string title( const std::string& key );
  std::string description( const std::string& key );
};


#endif  // ! STLFEATUREPLUGIN_H
