/*  -*- c++ -*-  (for Emacs)
 *
 *  stlrecogniser.cpp
 *  Digest
 * 
 *  Created by Aidan Lane on Tue Jan 17 2006.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "stlrecogniser.h"

#include <iostream>


StlRecogniser::StlRecogniser() {
  cout << "StlRecogniser created" << endl;
}

StlRecogniser::~StlRecogniser() {
  cout << "StlRecogniser destroyed" << endl;
}

const map<string, string>& StlRecogniser::defaultParams() const {
  static map<string, string> p;
  cout << "StlRecogniser::defaultParams" << endl;
  if ( p.empty() ) {
    p["foo"] = "1.0";
    p["bar"] = "25";
    p["text"] = "hello";
  }
  return p;
}

bool StlRecogniser::initTraining( const list<string>& featureKeys,
				       const map<string, string>& params ) {
  cout << "StlRecogniser::initTraining using "
       << featureKeys.size() << " features" << endl;
  map<string, string>::const_iterator it = params.begin();
  while ( it != params.end() ) {
    cout << "param \"" << (*it).first << "\" = \"" << (*it).second << "\""<< endl;
    ++it;
  }
  return true;
}

bool StlRecogniser::examineSample( const StlFeatureVec& /*featureVec*/,
					const set<int>& /*classes*/ ) {
  cout << "StlRecogniser::examineSample" << endl;
  return true;
}

bool StlRecogniser::finaliseTraining() {
  cout << "StlRecogniser::finaliseTraining" << endl;
  return true;
}

bool StlRecogniser::writeModelFile( const string& fileName ) {
  cout << "StlRecogniser::writeModelFile: " << fileName << endl;
  return true;
}

bool StlRecogniser::readModelFile( const string& fileName ) {
  cout << "StlRecogniser::readModelFile: " << fileName << endl;
  return true;
}

StlStroke StlRecogniser::flatten( const StlStrokeList& strokes ) {
  cout << "StlRecogniser::flatten" << endl;
  return StlRecogniserInterface::flatten( strokes ); // use default impl
}

StlClassProbabilities
StlRecogniser::classify( const StlFeatureVec& /*featureVec*/ ) {
  cout << "StlRecogniser::classify" << endl;
  return StlClassProbabilities();
}
