/*  -*- c++ -*-  (for Emacs)
 *
 *  stlrecogniserplugin.cpp
 *  Digest
 * 
 *  Created by Aidan Lane on Wed Jan 18 2006.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "stlrecogniserplugin.h"

#include "stlrecogniser.h"

using namespace std;

EXPORT_STL_RECOGNISER_FACTORY_PLUGIN( StlRecogniserPlugin );


set<string> StlRecogniserPlugin::keys() {
  set<string> keyset;
  keyset.insert( StlRecogniser::classKey() );
  return keyset;
}

StlRecogniserInterface* StlRecogniserPlugin::create( const std::string& key ) {
  return ( key == StlRecogniser::classKey()
	   ? new StlRecogniser()
	   : 0 );
}

string StlRecogniserPlugin::title( const std::string& key ) {
  return ( key == StlRecogniser::classKey()
	   ? StlRecogniser::classTitle()
	   : string() );
}

string StlRecogniserPlugin::description( const std::string& key ) {
  return ( key == StlRecogniser::classKey()
	   ? StlRecogniser::classDescription()
	   : string() );
}
