/*  -*- c++ -*-  (for Emacs)
 *
 *  dag_recogniser.h
 *  Digest
 * 
 *  Created by Adrian Bickerstaffe on Tue Jan 17 2006.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef DAG_RECOGNISER_H
#define DAG_RECOGNISER_H

#include "stlrecogniserinterface.h"
#include "svm_recogniser.h"
#include "multiclass_svm.h"

using namespace std;

// Class to represent a Directed Acyclic Graph (DAG) based gesture recogniser.
class dag_recogniser : public svm_recogniser<dag_svm>
{

public:

	DECLARE_STL_RECOGNISER_KEY("dagsvm");
	DECLARE_STL_RECOGNISER_TITLE("DAG-SVM Recogniser");
	DECLARE_STL_RECOGNISER_DESCRIPTION("This is a SVM recogniser which constructs "
	"a Directed Acyclic Graph (DAG) to perform multi-class classification.  The DAG "
	"structure provides a binary partitioning between pairs of classes at <I>each</I> node."
	"Assuming k target classes, the DAG will contain k*(k-1)/2 SVM decision nodes."
	"Consequently, training times for this recogniser can become unreasonably large for "
	"relatively small values of k.  An MCST-based recogniser is recommended in such cases."
	"<br><br>Adrian Bickerstaffe, 15/12/2005");
};

#endif  // ! DAG_RECOGNISER_H
