/*  -*- c++ -*-  (for Emacs)
 *
 *  nnsl_mcst_recogniser.h
 *  Digest
 * 
 *  Created by Adrian Bickerstaffe on Tue Jan 17 2006.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef NNSL_MCST_RECOGNISER_H
#define NNSL_MCST_RECOGNISER_H

#include "stlrecogniserinterface.h"
#include "svm_recogniser.h"
#include "multiclass_svm.h"

using namespace std;

// Class to represent a Minimal Cost Spanning Tree (MCST) based gesture recogniser.
// The tree structure is formed using Nearest Neighbour Single Linkage (NNSL).  
// This scheme iteratively merges classes based on the smallest Euclidean distance 
// between class centroids.
class nnsl_mcst_recogniser : public svm_recogniser<nnsl_classifier>
{

public:
	DECLARE_STL_RECOGNISER_KEY("mcst_nnsl");
	DECLARE_STL_RECOGNISER_TITLE( "MCST (NNSL) SVM Recogniser" );
	DECLARE_STL_RECOGNISER_DESCRIPTION("This is a SVM recogniser which constructs "
	"a Nearest-Neighbour Single-Link Minimal Cost Spanning Tree (NNSL-MCST) to perform "
	"multi-class classification.  Assuming k target classes, the MCST will contain "
	"(k-1) SVM decision nodes.  The structure of the MCST is determined using the NNSL "
	"approach and a Euclidean distance measure between centroid representative points. "
	"The MCST provides a binary partitioning between sets of classes at <I>each</I> node."
	"<br><br>Adrian Bickerstaffe, 15/12/2005");
};

#endif  // ! NNSL_MCST_RECOGNISER_H
