/*  -*- c++ -*-  (for Emacs)
 *
 *  svmplugin.cpp
 *  Digest
 * 
 *  Created by Adrian Bickerstaffe on Wed Jan 18 2006.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *	
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "svmplugin.h"

#include "librecognizer/dag_recogniser.h"
#include "librecognizer/nnsl_mcst_recogniser.h"
#include "librecognizer/nnal_mcst_recogniser.h"
#include "librecognizer/nncl_mcst_recogniser.h"

using namespace std;

EXPORT_STL_RECOGNISER_FACTORY_PLUGIN(SvmPlugin);

// Function creates the set of recogniser keys.
set<string> SvmPlugin::keys()
{
	set<string> keyset;

	keyset.insert(dag_recogniser::classKey());
	keyset.insert(nnsl_mcst_recogniser::classKey());
	keyset.insert(nnal_mcst_recogniser::classKey());
	keyset.insert(nncl_mcst_recogniser::classKey());

	return keyset;
}

// Function creates a new recogniser given a key.
StlRecogniserInterface* SvmPlugin::create(const std::string & key)
{
	if(key == dag_recogniser::classKey())
		return new dag_recogniser();
	else if (key == nnsl_mcst_recogniser::classKey())
		return new nnsl_mcst_recogniser();
	else if (key == nnal_mcst_recogniser::classKey())
		return new nnal_mcst_recogniser();
	else if (key == nncl_mcst_recogniser::classKey())
		return new nncl_mcst_recogniser();
		
	return 0;
}

// Function returns the title of a recogniser given its key.
string SvmPlugin::title(const std::string & key)
{
	if(key == dag_recogniser::classKey())
		return dag_recogniser::classTitle();
	else if(key == nnsl_mcst_recogniser::classKey())
		return nnsl_mcst_recogniser::classTitle();
	else if(key == nnal_mcst_recogniser::classKey())
		return nnal_mcst_recogniser::classTitle();
	else if(key == nncl_mcst_recogniser::classKey())
		return nncl_mcst_recogniser::classTitle();
		
	return 0;
}

// Function returns the description of a recogniser given its key.
string SvmPlugin::description(const std::string & key)
{
	if (key == dag_recogniser::classKey())
		return dag_recogniser::classDescription();
	else if (key == nnsl_mcst_recogniser::classKey())
		return nnsl_mcst_recogniser::classDescription();
	else if (key == nnal_mcst_recogniser::classKey())
		return nnal_mcst_recogniser::classDescription();
	else if (key == nncl_mcst_recogniser::classKey())
		return nncl_mcst_recogniser::classDescription();
			
	return 0;
}
