/*  -*- c++ -*-  (for Emacs)
 *
 *  sharedmacros.h
 * 
 *  Created by Aidan Lane on Fri Oct 28 2005.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef SHAREDMACROS_H
#define SHAREDMACROS_H


#include <QObject>


#ifndef DECLARE_CLASS_TYPE(TYPE)
#define DECLARE_CLASS_TYPE(TYPE)		\
  static int classType() { return TYPE; }	\
  virtual int type() const { return TYPE; }
#endif


#ifndef DECLARE_CLASS_CATEGORY(CATEGORY)
#define DECLARE_CLASS_CATEGORY(CATEGORY)		\
  static int classCategory() { return CATEGORY; }	\
  virtual int category() const { return CATEGORY; }
#endif


#ifndef DECLARE_CLASS_KEY(KEY)
#define DECLARE_CLASS_KEY(KEY)					\
  static const QByteArray& classKey() {				\
    static const QByteArray str(KEY);				\
    return str;							\
  }								\
  virtual const QByteArray& key() const { return classKey(); }
#endif

#ifndef DECLARE_CLASS_KEY_NONREF(KEY)
#define DECLARE_CLASS_KEY_NONREF(KEY)				\
  static QByteArray classKey() {				\
    static const QByteArray str(KEY);				\
    return str;							\
  }								\
  virtual QByteArray key() const { return classKey(); }
#endif


#ifndef DECLARE_CLASS_TITLE(TITLE)
#define DECLARE_CLASS_TITLE(TITLE)				\
  static const QString& classTitle() {				\
    static const QString str( QObject::tr(TITLE) );		\
    return str;							\
  }								\
  virtual const QString& title() const { return classTitle(); }
#endif

#ifndef DECLARE_CLASS_TITLE_NONREF(TITLE)
#define DECLARE_CLASS_TITLE_NONREF(TITLE)	       		\
  static QString classTitle() {					\
    static const QString str( QObject::tr(TITLE) );		\
    return str;							\
  }								\
  virtual QString title() const { return classTitle(); }
#endif

// Non tr() version, in case you want to pass a QString (rare):
#ifndef DECLARE_CLASS_TITLE_NONTR(TITLE)
#define DECLARE_CLASS_TITLE_NONTR(TITLE)			\
  static const QString& classTitle() {				\
    static const QString str( TITLE );				\
    return str;							\
  }								\
  virtual const QString& title() const { return classTitle(); }
#endif


#ifndef DECLARE_CLASS_DESCRIPTION(DESCRIPTION)
#define DECLARE_CLASS_DESCRIPTION(DESCRIPTION)				\
  static const QString& classDescription() {				\
    static const QString str( QObject::tr(DESCRIPTION) );		\
    return str;								\
  }									\
  virtual const QString& description() const { return classDescription(); }
#endif

#ifndef DECLARE_CLASS_DESCRIPTION_NONREF(DESCRIPTION)
#define DECLARE_CLASS_DESCRIPTION_NONREF(DESCRIPTION)			\
  static QString classDescription() {					\
    static const QString str( QObject::tr(DESCRIPTION) );		\
    return str;								\
  }									\
  virtual QString description() const { return classDescription(); }
#endif

// Non tr() version, in case you want to pass a QString (rare):
#ifndef DECLARE_CLASS_DESCRIPTION_NONTR(DESCRIPTION)
#define DECLARE_CLASS_DESCRIPTION_NONTR(DESCRIPTION)			\
  static const QString& classDescription() {				\
    static const QString str( DESCRIPTION );				\
    return str;								\
  }									\
  virtual const QString& description() const { return classDescription(); }
#endif

#ifndef DECLARE_CLASS_DESCRIPTION_METHODS
#define DECLARE_CLASS_DESCRIPTION_METHODS				\
  static const QString& classDescription();				\
  virtual const QString& description() const { return classDescription(); }
#endif

#ifndef DECLARE_CLASS_DESCRIPTION_METHODS_NONREF
#define DECLARE_CLASS_DESCRIPTION_METHODS_NONREF	       		\
  static QString classDescription();					\
  virtual QString description() const { return classDescription(); }
#endif


#endif  // ! SHAREDMACROS_H
