/*  -*- c++ -*-  (for Emacs)
 *
 *  stlrecognitioncommon.h
 *  Digest
 * 
 *  Created by Aidan Lane on Sun Apr 9 2006.
 *  Copyright (c) 2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef STLRECOGNITIONCOMMON_H
#define STLRECOGNITIONCOMMON_H


#include <list>
#include <map>
#include <sstream>
#include <string>
#include <vector>


typedef double                               StlClassProbabilityT;
typedef std::map<int, StlClassProbabilityT>  StlClassProbabilities;

typedef double                               StlFeatureResultT;
typedef std::vector<StlFeatureResultT>       StlFeatureVec;


typedef float     StlStrokeCoordT;
typedef float     StlStrokePressureT;
typedef uint32_t  StlStrokeTimeT;

struct StlStrokePoint {
  StlStrokePoint( StlStrokeCoordT x = 0.0,
		  StlStrokeCoordT y = 0.0,
		  StlStrokePressureT pressure  = 0.0,
		  StlStrokeTimeT milliTime = 0 )
    : x(x),
      y(y),
      pressure(pressure),
      milliTime(milliTime)
  {}

  StlStrokeCoordT x;
  StlStrokeCoordT y;
  StlStrokePressureT pressure;
  StlStrokeTimeT milliTime;
#if 0
  float rotation;
  float xTilt;
  float yTilt;
#endif
};

typedef std::vector<StlStrokePoint>  StlStroke;
typedef std::list<StlStroke>         StlStrokeList;


template <class T>
bool from_string( T& t,
                  const std::string& s, 
                  std::ios_base& (*f)(std::ios_base&) = std::dec ) {
  std::istringstream iss(s);
  return !(iss >> f >> t).fail();
}


#endif  // ! STLRECOGNITIONCOMMON_H
