/*  -*- c++ -*-  (for Emacs)
 *
 *  standardfeatures.h
 *  Digest
 * 
 *  Created by Aidan Lane on Mon Jul 11 2005.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef STANDARDFEATURES_H
#define STANDARDFEATURES_H


#include "stlfeatureinterface.h"


#define DECLARE_STL_FEATURE_CALCVALUE_METHODS									\
  static StlFeatureResultT														\
  classCalcValue( const StlStroke& stroke, bool* ok = 0 );						\
  StlFeatureResultT calcValue( const StlStroke& stroke, bool* ok = 0 ) const	\
  { return classCalcValue(stroke, ok); }


class CosInitAngleFeature : public StlFeatureInterface {
public:
  DECLARE_STL_FEATURE_KEY( "cosinitangle" );
  DECLARE_STL_FEATURE_TITLE( "Cosine of Initial Angle" );
  DECLARE_STL_FEATURE_DESCRIPTION_METHODS;
  DECLARE_STL_FEATURE_CALCVALUE_METHODS;
};

class SinInitAngleFeature : public StlFeatureInterface {
public:
  DECLARE_STL_FEATURE_KEY( "sininitangle" );
  DECLARE_STL_FEATURE_TITLE( "Sine of Initial Angle" );
  DECLARE_STL_FEATURE_DESCRIPTION_METHODS;
  DECLARE_STL_FEATURE_CALCVALUE_METHODS;
};

class BBoxDiagLengthFeature : public StlFeatureInterface {
public:
  DECLARE_STL_FEATURE_KEY( "bboxdiaglength" );
  DECLARE_STL_FEATURE_TITLE( "Bounding Box Diagonal Length" );
  DECLARE_STL_FEATURE_DESCRIPTION_METHODS;
  DECLARE_STL_FEATURE_CALCVALUE_METHODS;
};

class BBoxDiagAngleFeature : public StlFeatureInterface {
public:
  DECLARE_STL_FEATURE_KEY( "bboxdiagangle" );
  DECLARE_STL_FEATURE_TITLE( "Bounding Box Diagonal Angle" );
  DECLARE_STL_FEATURE_DESCRIPTION_METHODS;
  DECLARE_STL_FEATURE_CALCVALUE_METHODS;
};

class FirstToLastDistFeature : public StlFeatureInterface {
public:
  DECLARE_STL_FEATURE_KEY( "firsttolastdist" );
  DECLARE_STL_FEATURE_TITLE( "First to Last Point Distance" );
  DECLARE_STL_FEATURE_DESCRIPTION_METHODS;
  DECLARE_STL_FEATURE_CALCVALUE_METHODS;
};

class CosFirstToLastAngleFeature : public StlFeatureInterface {
public:
  DECLARE_STL_FEATURE_KEY( "cosfirsttolastangle" );
  DECLARE_STL_FEATURE_TITLE( "Cosine of First to Last Point Angle" );
  DECLARE_STL_FEATURE_DESCRIPTION_METHODS;
  DECLARE_STL_FEATURE_CALCVALUE_METHODS;
};

class SinFirstToLastAngleFeature : public StlFeatureInterface {
public:
  DECLARE_STL_FEATURE_KEY( "sinfirsttolastangle" );
  DECLARE_STL_FEATURE_TITLE( "Sine of First to Last Point Angle" );
  DECLARE_STL_FEATURE_DESCRIPTION_METHODS;
  DECLARE_STL_FEATURE_CALCVALUE_METHODS;
};

class TotalGestureLengthFeature : public StlFeatureInterface {
public:
  DECLARE_STL_FEATURE_KEY( "totalgesturelength" );
  DECLARE_STL_FEATURE_TITLE( "Total Gesture Length" );
  DECLARE_STL_FEATURE_DESCRIPTION_METHODS;
  DECLARE_STL_FEATURE_CALCVALUE_METHODS;
};

class TotalAngleTraversedFeature : public StlFeatureInterface {
public:
  DECLARE_STL_FEATURE_KEY( "totalangletraversed" );
  DECLARE_STL_FEATURE_TITLE( "Total Angle Traversed" );
  DECLARE_STL_FEATURE_DESCRIPTION_METHODS;
  DECLARE_STL_FEATURE_CALCVALUE_METHODS;
};

class TotalAbsAngleTraversedFeature : public StlFeatureInterface {
public:
  DECLARE_STL_FEATURE_KEY( "totalabsangletraversed" );
  DECLARE_STL_FEATURE_TITLE( "Total Absolute Angle Traversed" );
  DECLARE_STL_FEATURE_DESCRIPTION_METHODS;
  DECLARE_STL_FEATURE_CALCVALUE_METHODS;
};

class TotalSqrdAngleTraversedFeature : public StlFeatureInterface {
public:
  DECLARE_STL_FEATURE_KEY( "totalsqrdangletraversed" );
  DECLARE_STL_FEATURE_TITLE( "Total Squared Angle Traversed" );
  DECLARE_STL_FEATURE_DESCRIPTION_METHODS;
  DECLARE_STL_FEATURE_CALCVALUE_METHODS;
};

class MaxSqrdSpeedFeature : public StlFeatureInterface {
public:
  DECLARE_STL_FEATURE_KEY( "maxsqrdspeed" );
  DECLARE_STL_FEATURE_TITLE( "Maximum Squared Speed" );
  DECLARE_STL_FEATURE_DESCRIPTION_METHODS;
  DECLARE_STL_FEATURE_CALCVALUE_METHODS;
};

class DurationFeature : public StlFeatureInterface {
public:
  DECLARE_STL_FEATURE_KEY( "duration" );
  DECLARE_STL_FEATURE_TITLE( "Duration" );
  DECLARE_STL_FEATURE_DESCRIPTION_METHODS;
  DECLARE_STL_FEATURE_CALCVALUE_METHODS;
};


#endif  // ! STANDARDFEATURES_H
