/*  -*- c++ -*-  (for Emacs)
 *
 *  common.h
 *  Digest
 * 
 *  Created by Adrian Bickerstaffe on 11/5/2006.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
 
#ifndef COMMON_H
#define COMMON_H

#include <vector>
#include <iostream>
#include <fstream>

#include "stlrecognitioncommon.h"

using namespace std;

//// Operator function prototypes ////

// Operator for sorting strokes according to their down-pen time.
bool operator<(const StlStroke &, const StlStroke &);
// Compare the x coordinates of two points.
bool x_compare(const StlStrokePoint &, const StlStrokePoint &);
// Compare the y coordinates of two points.
bool y_compare(const StlStrokePoint &, const StlStrokePoint &);

////////////////////////

// Functions which operate on strokes but no not belong to any 
// specific class.
StlFeatureVec extract_features(const StlStroke &);
void find_coordinate_means(const StlStroke &, double &, double &);
double calc_length(const StlStroke &);
double calc_relative_length(const StlStroke &);
double inside_angle(const StlStrokePoint &, const StlStrokePoint &,
					const StlStrokePoint &);

void print_gesture(const StlStrokeList &, ostream &);
void print_stroke(const StlStroke &, ostream &);
void print_features(const StlFeatureVec &, ostream &);
void print_classification_probs(const StlClassProbabilities &, ostream &);

////////////////////////

// Class represents a bounding box which is to be formed around
// an StlStroke.
class bounding_box
{
public:
	enum quadrants{NW, NE, SE, SW};
	enum density_types{equal, upper, lower};
	
	bounding_box(void);
	bounding_box(const StlStroke &);
	bounding_box(const StlStrokeCoordT &, const StlStrokeCoordT &, 
				 const StlStrokeCoordT &, const StlStrokeCoordT &);
		
	double area(void) const;
	long double diagonal_length(void) const;
	long double top_edge_angle(const StlStroke &) const;
	
	int find_quadrant(const StlStrokePoint &) const;
	int classify_point_density(const StlStroke &) const;
	
private:	
	void find_limits(const StlStroke &);
	bool check_vertices(const StlStrokeCoordT &, const StlStrokeCoordT &, 
						const StlStrokeCoordT &, const StlStrokeCoordT &) const;
								  
	StlStrokeCoordT x_low, y_low, x_high, y_high;
};

#endif  // !COMMON_H
