// Keep this here in case it needs to be pasted into the
// recognizerProxy.h file created by javah.

//#ifdef __APPLE__
//#  include <JavaVM/jni.h>
//#else
//#  include <jni.h>
//#endif /* __APPLE__ */

package librecognizer;

// A class to wrap the C++ recognizer class
public class recognizerProxy
{
	// Load the native library upon creation
	static
	{
		try
		{
			System.loadLibrary("recognizer");
		}
		catch(java.lang.UnsatisfiedLinkError e)
		{
			System.out.println(e);
		}
	}
	
	// Constructor initializes the native side by creating a
	// new recognizer.
	public recognizerProxy()
	{
		recognizerPtr = 0;
		initCppSide();
	}
	
	// Functon to create a new recognizer and store the pointer
	// in this class.
	private native void initCppSide();
	// Function to load a trained recognizer from file.
	public native boolean readModelFile(String filename);
	// Function to classify a serialized stroke.
	public native int classifySample(float[] stroke);
	// Function to probabilistically classify serialized strokes
	public native float[] classifySampleProb(float[] stroke);

	// Main a pointer to the native recognizer here.
	private long recognizerPtr;
}
