/*  -*- c++ -*-  (for Emacs)
 *
 *  stlfeatureinterface.h
 *  Digest
 * 
 *  Created by Aidan Lane on Sun Apr 9 2006.
 *  Copyright (c) 2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef STLFEATUREINTERFACE_H
#define STLFEATUREINTERFACE_H


// TODO: remove what we don't need:
#include <algorithm>
#include <list>
#include <map>
#include <set>
#include <sstream>
#include <string>
#include <vector>

#include "stlrecognitioncommon.h"


#ifndef DECLARE_STL_FEATURE_KEY
#define DECLARE_STL_FEATURE_KEY(KEY)				\
  static const std::string& classKey() {			\
    static const std::string str(KEY);				\
    return str;							\
  }								\
  virtual const std::string& key() const { return classKey(); }
#endif

#ifndef DECLARE_STL_FEATURE_TITLE
#define DECLARE_STL_FEATURE_TITLE(TITLE)				\
  static const std::string& classTitle() {				\
    static const std::string str(TITLE);				\
    return str;								\
  }									\
  virtual const std::string& title() const { return classTitle(); }
#endif

#ifndef DECLARE_STL_FEATURE_DESCRIPTION
#define DECLARE_STL_FEATURE_DESCRIPTION(DESCRIPTION)			\
  static const std::string& classDescription() {			\
    static const std::string str(DESCRIPTION);				\
    return str;								\
  }									\
  virtual const std::string& description() const { return classDescription(); }
#endif

#ifndef DECLARE_STL_FEATURE_DESCRIPTION_METHODS
#define DECLARE_STL_FEATURE_DESCRIPTION_METHODS				\
  static const std::string& classDescription();				\
  virtual const std::string& description() const { return classDescription(); }
#endif


/*!
  \brief The StlFeatureInterface class is an abstract feature base class
         that is well suited to plugins, as it does not require Qt, only the
         C++ STL.
 
  Note that this class does not call "using namespace std", as that may not be
  wanted by the feature implementer. Hence, in the places where STL containers
  are used, they are prefixed with "std::".
 */
class StlFeatureInterface {

public:
  virtual ~StlFeatureInterface() {}

  virtual const std::string& key() const = 0;
  virtual const std::string& title() const = 0;
  virtual const std::string& description() const = 0;

  virtual StlFeatureResultT
  calcValue( const StlStroke& stroke, bool* ok = 0 ) const = 0;
};


#endif  // ! STLFEATUREINTERFACE_H
