// Rational.C
//
// CSE2305 Tute 4 solution by Jon McCormack
//


#include "Rational.h"
#include <strstream>

using namespace std;

// Constructor -- note the use of defaults in the header

Rational::Rational(int numerator, int denominator)
	: n(numerator), d(denominator) {
	reduce();
}

Rational::Rational(const Rational& r)
	: n(r.n), d(r.d) {
	// this will already be reduced
}

int Rational::getNumerator() const {
	return n;
}

int Rational::getDenominator() const {
	return d;
}

double Rational::asDouble() const {
	return (double)n/(double)d;
}

string Rational::asString() const {
	strstream s;
	s << n << '/' << d << ends;
	return string(s.str());
}

void Rational::set(int numerator, int denominator) {
	n = numerator;
	d = denominator;
	reduce();
}

Rational& Rational::operator=(const Rational& rhs) {
	n = rhs.n;
	d = rhs.d;
	return *this;
}

Rational Rational::operator+(const Rational& rhs) {
	if (d == rhs.d) { // no need for conversion
		return Rational(n + rhs.n, d);
	}
	return Rational(n * rhs.d + rhs.n * d, d * rhs.d);
}

Rational Rational::operator- (const Rational& rhs) {
	if (d == rhs.d) { // no need for conversion
		return Rational(n - rhs.n, d);
	}
	return Rational(n * rhs.d - rhs.n * d, d * rhs.d);
}

Rational Rational::operator* (const Rational& rhs) {
	return Rational(n * rhs.n, d * rhs.d);
}

Rational Rational::operator/ (const Rational& rhs) {
	return Rational(n * rhs.d, d * rhs.n);
}


bool Rational::operator<( const Rational& rhs ) const {
	return asDouble() < rhs.asDouble();
}

bool Rational::operator<=( const Rational& rhs ) const {
	return !(*this > rhs);
}

bool Rational::operator>( const Rational& rhs ) const {
	return asDouble() > rhs.asDouble();
}

bool Rational::operator>=( const Rational& rhs ) const {
	return !(*this < rhs);
}

bool Rational::operator==( const Rational& rhs ) const {
	if (d == rhs.d) {
		return (n == rhs.n) ? true : false;
	}
	return ((n * rhs.d) == (rhs.n * d));
}

bool Rational::operator!=( const Rational& rhs ) const {
	return !( *this == rhs);
}

ostream& Rational::print(ostream& s) const {
	return s << asString();
}

int Rational::gcd(int u, int v) {
	// find the greatest common divisor using euclid's algorithm
	//
	int t;
	while (u > 0) {
		if (u < v) {
			// swap
			t = u; u = v; v = t;
		}
		u -= v;
	}
	return v;
}

void Rational::reduce(void) {
	// reduce the rational to its lowest terms
	//
	int divisor = gcd(abs(n), abs(d));
	if (divisor > 1) {
		n /= divisor;
		d /= divisor;
	}
}

// Rational.cpp
