// Tester.C
//
// Tests the Rational class
//
// Jon McCormack, August 2002
//

#include "Tester.h"
#include "Rational.h"
#include <iostream>

using namespace std;

Tester::Tester()  {

}

Tester::~Tester() {

}

bool 
Tester::test(int level) {
	if (level <  1) return false;
	return actualTest(level);
}
 
bool
Tester::actualTest(int level) {
	int i;
	for (i = 1; i < level; ++i) {
		cout << "fibonacci(" << i << ") = " << fibonacci(i) << endl;
	}
	cout << "harmonic(" << level << ") = " << harmonicNumber(level) << endl;
	Rational pi = leibnizPi(level);
	cout << "Pi/4 by Leibniz series: " << pi;
	cout << " = " << pi.asDouble() << 
		" (out by " << 0.785398 - pi.asDouble() << ")" << endl;
	Rational angle(2,1); 
	taylor(angle, 4);
	return true;
}

Rational
Tester::fibonacci(int n) {
	int j, k;
	Rational total;

	for (k = 1; k < n; k++) {
		total = total + Rational(k, n-k);
	}
	return total;
}

void
Tester::taylor(const Rational& z, int level) {
	int n, c = -1, nf = 1;
	Rational zn(z), sine(z), cosine(1,1);

	// calculate sin(z) and cos(z) using taylor series...
	for (n = 1; n < level; ++n) {
		zn = zn * z;
		nf = nf * (2 * n);
		cosine = cosine + (zn * Rational(c, nf));
		zn = zn * z;
		nf = nf * (2 * n + 1); 
		sine = sine + (zn * Rational (c , nf));
		c *= -1;
	}
	cout << "sin(" << z << ") = " << sine << 
					" (" << sine.asDouble() << ")" <<endl;
	cout << "cos(" << z << ") = " << cosine << 
					" (" << cosine.asDouble() << ")" <<endl;
}


Rational
Tester::harmonicNumber(int n) {
	Rational hn(0,1);
	int i;
	for (i = 1; i <= n; ++i) {
		hn = hn + Rational(1,i);
	}
	return hn;
}

Rational
Tester::leibnizPi(int n) {
	int j, c = -1;
	Rational piOn4(1,1);
	for (j = 1; j <= n; ++j) {
		piOn4 = piOn4 + Rational(c,2 * j + 1);
		c *= -1;
	}
	return piOn4;
}

// Tester.C


